/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TypeSerializerSchemaCompatibility<T> {
    private final Type resultType;
    private final TypeSerializer<T> reconfiguredNewSerializer;

    public static <T> TypeSerializerSchemaCompatibility<T> compatibleAsIs() {
        return new TypeSerializerSchemaCompatibility<T>(Type.COMPATIBLE_AS_IS, null);
    }

    public static <T> TypeSerializerSchemaCompatibility<T> compatibleAfterMigration() {
        return new TypeSerializerSchemaCompatibility<T>(Type.COMPATIBLE_AFTER_MIGRATION, null);
    }

    public static <T> TypeSerializerSchemaCompatibility<T> compatibleWithReconfiguredSerializer(TypeSerializer<T> reconfiguredSerializer) {
        return new TypeSerializerSchemaCompatibility<T>(Type.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER, Preconditions.checkNotNull(reconfiguredSerializer));
    }

    public static <T> TypeSerializerSchemaCompatibility<T> incompatible() {
        return new TypeSerializerSchemaCompatibility<T>(Type.INCOMPATIBLE, null);
    }

    private TypeSerializerSchemaCompatibility(Type resultType, @Nullable TypeSerializer<T> reconfiguredNewSerializer) {
        this.resultType = Preconditions.checkNotNull(resultType);
        this.reconfiguredNewSerializer = reconfiguredNewSerializer;
    }

    public boolean isCompatibleAsIs() {
        return this.resultType == Type.COMPATIBLE_AS_IS;
    }

    public boolean isCompatibleAfterMigration() {
        return this.resultType == Type.COMPATIBLE_AFTER_MIGRATION;
    }

    public boolean isCompatibleWithReconfiguredSerializer() {
        return this.resultType == Type.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER;
    }

    public TypeSerializer<T> getReconfiguredSerializer() {
        Preconditions.checkState(this.isCompatibleWithReconfiguredSerializer(), "It is only possible to get a reconfigured serializer if the compatibility type is %s, but the type is %s", new Object[]{Type.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER, this.resultType});
        return this.reconfiguredNewSerializer;
    }

    public boolean isIncompatible() {
        return this.resultType == Type.INCOMPATIBLE;
    }

    public String toString() {
        return "TypeSerializerSchemaCompatibility{resultType=" + this.resultType + ", reconfiguredNewSerializer=" + this.reconfiguredNewSerializer + "}";
    }

    static enum Type {
        COMPATIBLE_AS_IS,
        COMPATIBLE_AFTER_MIGRATION,
        COMPATIBLE_WITH_RECONFIGURED_SERIALIZER,
        INCOMPATIBLE;

    }
}

