/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TableDistribution {
    private final Kind kind;
    @Nullable
    private final Integer bucketCount;
    private final List<String> bucketKeys;

    private TableDistribution(Kind kind, @Nullable Integer bucketCount, List<String> bucketKeys) {
        this.kind = Preconditions.checkNotNull(kind, "Distribution kind must not be null.");
        this.bucketCount = bucketCount;
        this.bucketKeys = Preconditions.checkNotNull(bucketKeys, "Bucket keys must not be null.");
    }

    public static TableDistribution of(Kind kind, @Nullable Integer bucketCount, List<String> bucketKeys) {
        return new TableDistribution(kind, bucketCount, bucketKeys);
    }

    public static TableDistribution ofUnknown(int bucketCount) {
        return new TableDistribution(Kind.UNKNOWN, bucketCount, Collections.emptyList());
    }

    public static TableDistribution ofUnknown(List<String> bucketKeys, @Nullable Integer bucketCount) {
        return new TableDistribution(Kind.UNKNOWN, bucketCount, bucketKeys);
    }

    public static TableDistribution ofHash(List<String> bucketKeys, @Nullable Integer bucketCount) {
        return new TableDistribution(Kind.HASH, bucketCount, bucketKeys);
    }

    public static TableDistribution ofRange(List<String> bucketKeys, @Nullable Integer bucketCount) {
        return new TableDistribution(Kind.RANGE, bucketCount, bucketKeys);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDistribution that = (TableDistribution)o;
        return this.kind == that.kind && Objects.equals(this.bucketCount, that.bucketCount) && Objects.equals(this.bucketKeys, that.bucketKeys);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.bucketCount, this.bucketKeys});
    }

    public Kind getKind() {
        return this.kind;
    }

    public List<String> getBucketKeys() {
        return this.bucketKeys;
    }

    public Optional<Integer> getBucketCount() {
        return Optional.ofNullable(this.bucketCount);
    }

    private String asSerializableString() {
        if (this.getBucketKeys().isEmpty() && this.getBucketCount().isPresent() && this.getBucketCount().get() != 0) {
            return "DISTRIBUTED INTO " + this.getBucketCount().get() + " BUCKETS\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DISTRIBUTED BY ");
        if (this.getKind() != null && this.getKind() != Kind.UNKNOWN) {
            sb.append((Object)this.getKind());
        }
        sb.append("(");
        sb.append(this.getBucketKeys().stream().map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", ")));
        sb.append(")");
        if (this.getBucketCount().isPresent() && this.getBucketCount().get() != 0) {
            sb.append(" INTO ");
            sb.append(this.getBucketCount().get());
            sb.append(" BUCKETS");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.asSerializableString();
    }

    @PublicEvolving
    public static enum Kind {
        UNKNOWN,
        HASH,
        RANGE;

    }
}

