/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.util.Preconditions;

public class ResourceManagerProcessContext {
    private final Configuration rmConfig;
    private final ResourceID resourceId;
    private final ResourceManagerRuntimeServicesConfiguration rmRuntimeServicesConfig;
    private final RpcService rpcService;
    private final HighAvailabilityServices highAvailabilityServices;
    private final HeartbeatServices heartbeatServices;
    private final DelegationTokenManager delegationTokenManager;
    private final FatalErrorHandler fatalErrorHandler;
    private final ClusterInformation clusterInformation;
    @Nullable
    private final String webInterfaceUrl;
    private final MetricRegistry metricRegistry;
    private final String hostname;
    private final Executor ioExecutor;

    public ResourceManagerProcessContext(Configuration rmConfig, ResourceID resourceId, ResourceManagerRuntimeServicesConfiguration rmRuntimeServicesConfig, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, MetricRegistry metricRegistry, String hostname, Executor ioExecutor) {
        this.rmConfig = Preconditions.checkNotNull(rmConfig);
        this.resourceId = Preconditions.checkNotNull(resourceId);
        this.rmRuntimeServicesConfig = Preconditions.checkNotNull(rmRuntimeServicesConfig);
        this.rpcService = Preconditions.checkNotNull(rpcService);
        this.highAvailabilityServices = Preconditions.checkNotNull(highAvailabilityServices);
        this.heartbeatServices = Preconditions.checkNotNull(heartbeatServices);
        this.delegationTokenManager = Preconditions.checkNotNull(delegationTokenManager);
        this.fatalErrorHandler = Preconditions.checkNotNull(fatalErrorHandler);
        this.clusterInformation = Preconditions.checkNotNull(clusterInformation);
        this.metricRegistry = Preconditions.checkNotNull(metricRegistry);
        this.hostname = Preconditions.checkNotNull(hostname);
        this.ioExecutor = Preconditions.checkNotNull(ioExecutor);
        this.webInterfaceUrl = webInterfaceUrl;
    }

    public Configuration getRmConfig() {
        return this.rmConfig;
    }

    public ResourceID getResourceId() {
        return this.resourceId;
    }

    public ResourceManagerRuntimeServicesConfiguration getRmRuntimeServicesConfig() {
        return this.rmRuntimeServicesConfig;
    }

    public RpcService getRpcService() {
        return this.rpcService;
    }

    public HighAvailabilityServices getHighAvailabilityServices() {
        return this.highAvailabilityServices;
    }

    public HeartbeatServices getHeartbeatServices() {
        return this.heartbeatServices;
    }

    public DelegationTokenManager getDelegationTokenManager() {
        return this.delegationTokenManager;
    }

    public FatalErrorHandler getFatalErrorHandler() {
        return this.fatalErrorHandler;
    }

    public ClusterInformation getClusterInformation() {
        return this.clusterInformation;
    }

    @Nullable
    public String getWebInterfaceUrl() {
        return this.webInterfaceUrl;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }
}

