/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.OffsetAwareOutputStream;
import org.apache.flink.core.fs.RefCountedFile;
import org.apache.flink.util.IOUtils;

@Internal
public class RefCountedFileWithStream
extends RefCountedFile {
    private final OffsetAwareOutputStream stream;

    private RefCountedFileWithStream(File file, OutputStream currentOut, long bytesInCurrentPart) {
        super(file);
        this.stream = new OffsetAwareOutputStream(currentOut, bytesInCurrentPart);
    }

    public OffsetAwareOutputStream getStream() {
        return this.stream;
    }

    public long getLength() {
        return this.stream.getLength();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.requireOpened();
        if (len > 0) {
            this.stream.write(b, off, len);
        }
    }

    void flush() throws IOException {
        this.requireOpened();
        this.stream.flush();
    }

    void closeStream() {
        if (!this.closed) {
            IOUtils.closeQuietly(this.stream);
            this.closed = true;
        }
    }

    private void requireOpened() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
    }

    public static RefCountedFileWithStream newFile(File file, OutputStream currentOut) throws IOException {
        return new RefCountedFileWithStream(file, currentOut, 0L);
    }

    public static RefCountedFileWithStream restoredFile(File file, OutputStream currentOut, long bytesInCurrentPart) {
        return new RefCountedFileWithStream(file, currentOut, bytesInCurrentPart);
    }
}

