/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.util.Preconditions;

@Internal
public class CompilePlanOperation
implements Operation {
    private final String filePath;
    private final boolean ifNotExists;
    private final Operation operation;

    public CompilePlanOperation(String filePath, boolean ifNotExists, Operation operation) {
        Preconditions.checkArgument(operation instanceof StatementSetOperation || operation instanceof ModifyOperation, "child operation of CompileOperation must be either a ModifyOperation or a StatementSetOperation");
        this.filePath = filePath;
        this.ifNotExists = ifNotExists;
        this.operation = operation;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public String asSummaryString() {
        return String.format(this.ifNotExists ? "COMPILE PLAN '%s' IF NOT EXISTS FOR %s" : "COMPILE PLAN '%s' FOR %s", this.filePath, this.operation.asSummaryString());
    }
}

