/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc;

import org.apache.flink.table.jdbc.utils.DriverUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

public class ColumnInfo {
    private static final int VARBINARY_MAX = 0x40000000;
    private static final int TIME_ZONE_MAX = 40;
    private static final int TIME_MAX = "HH:mm:ss.SSS".length();
    private static final int TIMESTAMP_MAX = "yyyy-MM-dd HH:mm:ss.SSS".length();
    private static final int TIMESTAMP_WITH_TIME_ZONE_MAX = TIMESTAMP_MAX + 40;
    private static final int DATE_MAX = "yyyy-MM-dd".length();
    private static final int STRUCT_MAX = 0x6400000;
    private final int columnType;
    private final String columnTypeName;
    private final boolean nullable;
    private final boolean signed;
    private final int precision;
    private final int scale;
    private final int columnDisplaySize;
    private final String columnName;

    private ColumnInfo(int columnType, String columnTypeName, boolean nullable, boolean signed, int precision, int scale, int columnDisplaySize, String columnName) {
        this.columnType = columnType;
        this.columnTypeName = columnTypeName;
        this.nullable = nullable;
        this.signed = signed;
        this.precision = precision;
        this.scale = scale;
        this.columnDisplaySize = columnDisplaySize;
        this.columnName = DriverUtils.checkNotNull(columnName, "column name cannot be null");
    }

    public int getColumnType() {
        return this.columnType;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String columnTypeName() {
        return this.columnTypeName;
    }

    public static ColumnInfo fromLogicalType(String columnName, LogicalType type) {
        Builder builder = new Builder().columnName(columnName).nullable(type.isNullable()).signed(type.is(LogicalTypeFamily.NUMERIC)).columnTypeName(type.asSummaryString());
        if (type instanceof BooleanType) {
            builder.columnType(16).columnDisplaySize(5);
        } else if (type instanceof TinyIntType) {
            builder.columnType(-6).precision(3).scale(0).columnDisplaySize(4);
        } else if (type instanceof SmallIntType) {
            builder.columnType(5).precision(5).scale(0).columnDisplaySize(6);
        } else if (type instanceof IntType) {
            builder.columnType(4).precision(10).scale(0).columnDisplaySize(11);
        } else if (type instanceof BigIntType) {
            builder.columnType(-5).precision(19).scale(0).columnDisplaySize(20);
        } else if (type instanceof FloatType) {
            builder.columnType(6).precision(9).scale(0).columnDisplaySize(16);
        } else if (type instanceof DoubleType) {
            builder.columnType(8).precision(17).scale(0).columnDisplaySize(24);
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            builder.columnType(3).columnDisplaySize(decimalType.getPrecision() + 2).precision(decimalType.getPrecision()).scale(decimalType.getScale());
        } else if (type instanceof CharType) {
            CharType charType = (CharType)type;
            builder.columnType(1).scale(0).precision(charType.getLength()).columnDisplaySize(charType.getLength());
        } else if (type instanceof VarCharType) {
            builder.columnType(12).scale(0).precision(0x40000000).columnDisplaySize(0x40000000);
        } else if (type instanceof BinaryType) {
            BinaryType binaryType = (BinaryType)type;
            builder.columnType(-2).scale(0).precision(binaryType.getLength()).columnDisplaySize(binaryType.getLength());
        } else if (type instanceof VarBinaryType) {
            builder.columnType(-3).scale(0).precision(0x40000000).columnDisplaySize(0x40000000);
        } else if (type instanceof DateType) {
            builder.columnType(91).scale(0).columnDisplaySize(DATE_MAX);
        } else if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            builder.columnType(92).precision(timeType.getPrecision()).scale(0).columnDisplaySize(TIME_MAX);
        } else if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            builder.columnType(93).precision(timestampType.getPrecision()).scale(0).columnDisplaySize(TIMESTAMP_MAX);
        } else if (type instanceof LocalZonedTimestampType) {
            LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)type;
            builder.columnType(93).precision(localZonedTimestampType.getPrecision()).scale(0).columnDisplaySize(TIMESTAMP_MAX);
        } else if (type instanceof ZonedTimestampType) {
            ZonedTimestampType zonedTimestampType = (ZonedTimestampType)type;
            builder.columnType(2014).precision(zonedTimestampType.getPrecision()).scale(0).columnDisplaySize(TIMESTAMP_WITH_TIME_ZONE_MAX);
        } else if (type instanceof ArrayType) {
            builder.columnType(2003).scale(0).precision(0x6400000).columnDisplaySize(0x6400000);
        } else if (type instanceof MapType) {
            builder.columnType(2000).scale(0).precision(0x6400000).columnDisplaySize(0x6400000);
        } else if (type instanceof RowType) {
            builder.columnType(2002).precision(0x6400000).scale(0).columnDisplaySize(0x6400000);
        } else {
            throw new RuntimeException(String.format("Not supported type[%s]", type));
        }
        return builder.build();
    }

    private static class Builder {
        private int columnType;
        private String columnTypeName;
        private boolean nullable;
        private boolean signed;
        private int precision;
        private int scale;
        private int columnDisplaySize;
        private String columnName;

        private Builder() {
        }

        public Builder columnType(int columnType) {
            this.columnType = columnType;
            return this;
        }

        public Builder columnTypeName(String columnTypeName) {
            this.columnTypeName = columnTypeName;
            return this;
        }

        public Builder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder signed(boolean signed) {
            this.signed = signed;
            return this;
        }

        public Builder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder scale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder columnDisplaySize(int columnDisplaySize) {
            this.columnDisplaySize = columnDisplaySize;
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public ColumnInfo build() {
            return new ColumnInfo(this.columnType, this.columnTypeName, this.nullable, this.signed, this.precision, this.scale, this.columnDisplaySize, this.columnName);
        }
    }
}

