/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class ContextResolvedTable {
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private final ObjectIdentifier objectIdentifier;
    @Nullable
    private final Catalog catalog;
    private final ResolvedCatalogBaseTable<?> resolvedTable;
    private final boolean anonymous;

    public static ContextResolvedTable permanent(ObjectIdentifier identifier, Catalog catalog, ResolvedCatalogBaseTable<?> resolvedTable) {
        return new ContextResolvedTable(identifier, Preconditions.checkNotNull(catalog), resolvedTable, false);
    }

    public static ContextResolvedTable temporary(ObjectIdentifier identifier, ResolvedCatalogBaseTable<?> resolvedTable) {
        return new ContextResolvedTable(identifier, null, resolvedTable, false);
    }

    public static ContextResolvedTable anonymous(ResolvedCatalogBaseTable<?> resolvedTable) {
        return new ContextResolvedTable(ObjectIdentifier.ofAnonymous(ContextResolvedTable.generateAnonymousStringIdentifier(null, resolvedTable)), null, resolvedTable, true);
    }

    public static ContextResolvedTable anonymous(String hint, ResolvedCatalogBaseTable<?> resolvedTable) {
        return new ContextResolvedTable(ObjectIdentifier.ofAnonymous(ContextResolvedTable.generateAnonymousStringIdentifier(hint, resolvedTable)), null, resolvedTable, true);
    }

    private ContextResolvedTable(ObjectIdentifier objectIdentifier, @Nullable Catalog catalog, ResolvedCatalogBaseTable<?> resolvedTable, boolean anonymous) {
        this.objectIdentifier = Preconditions.checkNotNull(objectIdentifier);
        this.catalog = catalog;
        this.resolvedTable = Preconditions.checkNotNull(resolvedTable);
        this.anonymous = anonymous;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isTemporary() {
        return this.catalog == null;
    }

    public boolean isPermanent() {
        return !this.isTemporary();
    }

    public ObjectIdentifier getIdentifier() {
        return this.objectIdentifier;
    }

    public Optional<Catalog> getCatalog() {
        return Optional.ofNullable(this.catalog);
    }

    public <T extends ResolvedCatalogBaseTable<?>> T getResolvedTable() {
        return (T)this.resolvedTable;
    }

    public ResolvedSchema getResolvedSchema() {
        return this.resolvedTable.getResolvedSchema();
    }

    public <T extends CatalogBaseTable> T getTable() {
        return (T)this.resolvedTable.getOrigin();
    }

    public ContextResolvedTable toCatalogTable() {
        if (this.resolvedTable.getTableKind() == CatalogBaseTable.TableKind.MATERIALIZED_TABLE) {
            return ContextResolvedTable.permanent(this.objectIdentifier, this.catalog, ((ResolvedCatalogMaterializedTable)this.resolvedTable).toResolvedCatalogTable());
        }
        return this;
    }

    public ContextResolvedTable copy(Map<String, String> newOptions) {
        if (this.resolvedTable.getTableKind() == CatalogBaseTable.TableKind.VIEW) {
            throw new ValidationException(String.format("View '%s' cannot be enriched with new options.", this));
        }
        if (this.resolvedTable.getTableKind() == CatalogBaseTable.TableKind.MATERIALIZED_TABLE) {
            return ContextResolvedTable.permanent(this.objectIdentifier, this.catalog, ((ResolvedCatalogMaterializedTable)this.resolvedTable).copy((Map)newOptions));
        }
        return new ContextResolvedTable(this.objectIdentifier, this.catalog, (ResolvedCatalogBaseTable<?>)((Object)((ResolvedCatalogTable)this.resolvedTable).copy((Map)newOptions)), false);
    }

    public ContextResolvedTable copy(ResolvedSchema newSchema) {
        if (this.resolvedTable.getTableKind() == CatalogBaseTable.TableKind.MATERIALIZED_TABLE) {
            throw new ValidationException(String.format("Materialized table '%s' cannot be copied with new schema %s.", this, newSchema));
        }
        return new ContextResolvedTable(this.objectIdentifier, this.catalog, new ResolvedCatalogTable((CatalogTable)this.resolvedTable.getOrigin(), newSchema), false);
    }

    private static String generateAnonymousStringIdentifier(@Nullable String hint, ResolvedCatalogBaseTable<?> resolvedTable) {
        if (hint == null) {
            try {
                hint = resolvedTable.getOptions().get(FactoryUtil.CONNECTOR.key());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int id = uniqueId.incrementAndGet();
        if (hint == null) {
            return "*anonymous$" + id + "*";
        }
        return "*anonymous_" + hint + "$" + id + "*";
    }

    public String toString() {
        return this.objectIdentifier.asSummaryString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextResolvedTable that = (ContextResolvedTable)o;
        return this.anonymous == that.anonymous && Objects.equals(this.objectIdentifier, that.objectIdentifier) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.resolvedTable, that.resolvedTable);
    }

    public int hashCode() {
        return Objects.hash(this.objectIdentifier, this.catalog, this.resolvedTable, this.anonymous);
    }
}

