/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.config.memory.LegacyMemoryOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBackwardsCompatibilityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryBackwardsCompatibilityUtils.class);
    private final LegacyMemoryOptions legacyMemoryOptions;

    public MemoryBackwardsCompatibilityUtils(LegacyMemoryOptions legacyMemoryOptions) {
        this.legacyMemoryOptions = legacyMemoryOptions;
    }

    public Configuration getConfWithLegacyHeapSizeMappedToNewConfigOption(Configuration configuration, ConfigOption<MemorySize> configOption) {
        if (configuration.contains(configOption)) {
            return configuration;
        }
        return this.getLegacyHeapMemoryIfExplicitlyConfigured(configuration).map(legacyHeapSize -> {
            Configuration copiedConfig = new Configuration(configuration);
            copiedConfig.set((ConfigOption)configOption, legacyHeapSize);
            LOG.info("'{}' is not specified, use the configured deprecated task manager heap value ({}) for it.", (Object)configOption.key(), (Object)legacyHeapSize.toHumanReadableString());
            return copiedConfig;
        }).orElse(configuration);
    }

    private Optional<MemorySize> getLegacyHeapMemoryIfExplicitlyConfigured(Configuration configuration) {
        String totalProcessEnv = System.getenv(this.legacyMemoryOptions.getEnvVar());
        if (totalProcessEnv != null) {
            try {
                return Optional.of(MemorySize.parse(totalProcessEnv));
            }
            catch (Throwable t) {
                throw new IllegalConfigurationException("Cannot read total process memory size from environment variable value " + totalProcessEnv + '.', t);
            }
        }
        if (configuration.contains(this.legacyMemoryOptions.getHeap())) {
            return Optional.of(ProcessMemoryUtils.getMemorySizeFromConfig(configuration, this.legacyMemoryOptions.getHeap()));
        }
        if (configuration.contains(this.legacyMemoryOptions.getHeapMb())) {
            long legacyHeapMemoryMB = configuration.get(this.legacyMemoryOptions.getHeapMb()).intValue();
            if (legacyHeapMemoryMB < 0L) {
                throw new IllegalConfigurationException("Configured total process memory size (" + legacyHeapMemoryMB + "MB) must not be less than 0.");
            }
            return Optional.of(new MemorySize(legacyHeapMemoryMB << 20));
        }
        return Optional.empty();
    }
}

