/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.v2.StateDescriptor;

public class MapStateDescriptor<UK, UV>
extends StateDescriptor<UV> {
    @Nonnull
    private final TypeSerializer<UK> userKeySerializer;

    public MapStateDescriptor(String stateId, TypeInformation<UK> userKeyTypeInfo, TypeInformation<UV> userValueTypeInfo) {
        this(stateId, userKeyTypeInfo, userValueTypeInfo, new SerializerConfigImpl());
    }

    public MapStateDescriptor(String stateId, TypeInformation<UK> userKeyTypeInfo, TypeInformation<UV> userValueTypeInfo, SerializerConfig serializerConfig) {
        super(stateId, userValueTypeInfo, serializerConfig);
        this.userKeySerializer = userKeyTypeInfo.createSerializer(serializerConfig);
    }

    @Nonnull
    public TypeSerializer<UK> getUserKeySerializer() {
        return this.userKeySerializer.duplicate();
    }

    @Override
    public StateDescriptor.Type getType() {
        return StateDescriptor.Type.MAP;
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o) && this.userKeySerializer.equals(((MapStateDescriptor)o).userKeySerializer);
    }
}

