/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.io;

import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.hash.HashPartition;
import org.apache.flink.util.MutableObjectIterator;

public class HashPartitionIterator<BT, PT>
implements MutableObjectIterator<BT> {
    private final Iterator<HashPartition<BT, PT>> partitions;
    private final TypeSerializer<BT> serializer;
    private HashPartition<BT, PT> currentPartition;

    public HashPartitionIterator(Iterator<HashPartition<BT, PT>> partitions, TypeSerializer<BT> serializer) {
        this.partitions = partitions;
        this.serializer = serializer;
        this.currentPartition = null;
    }

    @Override
    public BT next(BT reuse) throws IOException {
        if (this.currentPartition == null) {
            if (!this.partitions.hasNext()) {
                return null;
            }
            this.currentPartition = this.partitions.next();
            this.currentPartition.setReadPosition(0L);
        }
        try {
            reuse = this.serializer.deserialize(reuse, this.currentPartition);
        }
        catch (EOFException e) {
            reuse = this.advanceAndRead(reuse);
        }
        return reuse;
    }

    @Override
    public BT next() throws IOException {
        if (this.currentPartition == null) {
            if (!this.partitions.hasNext()) {
                return null;
            }
            this.currentPartition = this.partitions.next();
            this.currentPartition.setReadPosition(0L);
        }
        try {
            return this.serializer.deserialize(this.currentPartition);
        }
        catch (EOFException e) {
            return this.advanceAndRead();
        }
    }

    private BT advanceAndRead(BT reuse) throws IOException {
        if (!this.partitions.hasNext()) {
            return null;
        }
        this.currentPartition = this.partitions.next();
        this.currentPartition.setReadPosition(0L);
        try {
            reuse = this.serializer.deserialize(reuse, this.currentPartition);
        }
        catch (EOFException e) {
            reuse = this.advanceAndRead(reuse);
        }
        return reuse;
    }

    private BT advanceAndRead() throws IOException {
        if (!this.partitions.hasNext()) {
            return null;
        }
        this.currentPartition = this.partitions.next();
        this.currentPartition.setReadPosition(0L);
        try {
            return this.serializer.deserialize(this.currentPartition);
        }
        catch (EOFException e) {
            return this.advanceAndRead();
        }
    }
}

