/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.RestartBackoffTimeStrategy;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class ExponentialDelayRestartBackoffTimeStrategy
implements RestartBackoffTimeStrategy {
    private static final long DEFAULT_NEXT_RESTART_TIMESTAMP = Integer.MIN_VALUE;
    private final long initialBackoffMS;
    private final long maxBackoffMS;
    private final double backoffMultiplier;
    private final long resetBackoffThresholdMS;
    private final double jitterFactor;
    private final int attemptsBeforeResetBackoff;
    private final Clock clock;
    private int currentRestartAttempt;
    private long nextRestartTimestamp;

    ExponentialDelayRestartBackoffTimeStrategy(Clock clock, long initialBackoffMS, long maxBackoffMS, double backoffMultiplier, long resetBackoffThresholdMS, double jitterFactor, int attemptsBeforeResetBackoff) {
        Preconditions.checkArgument(initialBackoffMS >= 1L, "Initial backoff must be at least 1.");
        Preconditions.checkArgument(maxBackoffMS >= 1L, "Maximum backoff must be at least 1.");
        Preconditions.checkArgument(initialBackoffMS <= maxBackoffMS, "Initial backoff cannot be higher than maximum backoff.");
        Preconditions.checkArgument(backoffMultiplier > 1.0, "Backoff multiplier must be greater than 1.");
        Preconditions.checkArgument(resetBackoffThresholdMS >= 1L, "Threshold duration for exponential backoff reset must be at least 1.");
        Preconditions.checkArgument(0.0 <= jitterFactor && jitterFactor <= 1.0, "Jitter factor must be >= 0 and <= 1.");
        Preconditions.checkArgument(attemptsBeforeResetBackoff >= 1, "The attemptsBeforeResetBackoff must be at least 1.");
        this.initialBackoffMS = initialBackoffMS;
        this.setInitialBackoff();
        this.maxBackoffMS = maxBackoffMS;
        this.backoffMultiplier = backoffMultiplier;
        this.resetBackoffThresholdMS = resetBackoffThresholdMS;
        this.jitterFactor = jitterFactor;
        this.attemptsBeforeResetBackoff = attemptsBeforeResetBackoff;
        this.clock = Preconditions.checkNotNull(clock);
        this.nextRestartTimestamp = Integer.MIN_VALUE;
    }

    @Override
    public boolean canRestart() {
        return this.currentRestartAttempt <= this.attemptsBeforeResetBackoff;
    }

    @Override
    public long getBackoffTime() {
        Preconditions.checkState(this.nextRestartTimestamp != Integer.MIN_VALUE, "Please call notifyFailure first.");
        return Math.max(0L, this.nextRestartTimestamp - this.clock.absoluteTimeMillis());
    }

    @Override
    public boolean notifyFailure(Throwable cause) {
        long now = this.clock.absoluteTimeMillis();
        if (now <= this.nextRestartTimestamp) {
            return false;
        }
        if (now - this.nextRestartTimestamp >= this.resetBackoffThresholdMS) {
            this.setInitialBackoff();
        }
        this.nextRestartTimestamp = now + this.calculateActualBackoffTime();
        ++this.currentRestartAttempt;
        return true;
    }

    @VisibleForTesting
    long getInitialBackoffMS() {
        return this.initialBackoffMS;
    }

    @VisibleForTesting
    long getMaxBackoffMS() {
        return this.maxBackoffMS;
    }

    @VisibleForTesting
    double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    @VisibleForTesting
    long getResetBackoffThresholdMS() {
        return this.resetBackoffThresholdMS;
    }

    @VisibleForTesting
    double getJitterFactor() {
        return this.jitterFactor;
    }

    @VisibleForTesting
    int getAttemptsBeforeResetBackoff() {
        return this.attemptsBeforeResetBackoff;
    }

    public String toString() {
        return "ExponentialDelayRestartBackoffTimeStrategy(initialBackoffMS=" + this.initialBackoffMS + ", maxBackoffMS=" + this.maxBackoffMS + ", backoffMultiplier=" + this.backoffMultiplier + ", resetBackoffThresholdMS=" + this.resetBackoffThresholdMS + ", jitterFactor=" + this.jitterFactor + ", attemptsBeforeResetBackoff=" + this.attemptsBeforeResetBackoff + ", currentRestartAttempt=" + this.currentRestartAttempt + ", nextRestartTimestamp=" + this.nextRestartTimestamp + ")";
    }

    private void setInitialBackoff() {
        this.currentRestartAttempt = 0;
    }

    private long calculateActualBackoffTime() {
        long currentBackoffTime = (long)((double)this.initialBackoffMS * Math.pow(this.backoffMultiplier, this.currentRestartAttempt));
        return Math.max(this.initialBackoffMS, Math.min(currentBackoffTime + this.calculateJitterBackoffMS(currentBackoffTime), this.maxBackoffMS));
    }

    private long calculateJitterBackoffMS(long currentBackoffMS) {
        if (this.jitterFactor == 0.0) {
            return 0L;
        }
        long offset = (long)((double)currentBackoffMS * this.jitterFactor);
        return ThreadLocalRandom.current().nextLong(-offset, offset + 1L);
    }

    public static ExponentialDelayRestartBackoffTimeStrategyFactory createFactory(Configuration configuration) {
        long initialBackoffMS = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF).toMillis();
        long maxBackoffMS = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF).toMillis();
        double backoffMultiplier = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER);
        long resetBackoffThresholdMS = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD).toMillis();
        double jitterFactor = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR);
        int attemptsBeforeResetBackoff = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_ATTEMPTS);
        return new ExponentialDelayRestartBackoffTimeStrategyFactory(initialBackoffMS, maxBackoffMS, backoffMultiplier, resetBackoffThresholdMS, jitterFactor, attemptsBeforeResetBackoff);
    }

    public static class ExponentialDelayRestartBackoffTimeStrategyFactory
    implements RestartBackoffTimeStrategy.Factory {
        private final Clock clock;
        private final long initialBackoffMS;
        private final long maxBackoffMS;
        private final double backoffMultiplier;
        private final long resetBackoffThresholdMS;
        private final double jitterFactor;
        private final int attemptsBeforeResetBackoff;

        public ExponentialDelayRestartBackoffTimeStrategyFactory(long initialBackoffMS, long maxBackoffMS, double backoffMultiplier, long resetBackoffThresholdMS, double jitterFactor, int attemptsBeforeResetBackoff) {
            this(SystemClock.getInstance(), initialBackoffMS, maxBackoffMS, backoffMultiplier, resetBackoffThresholdMS, jitterFactor, attemptsBeforeResetBackoff);
        }

        @VisibleForTesting
        ExponentialDelayRestartBackoffTimeStrategyFactory(Clock clock, long initialBackoffMS, long maxBackoffMS, double backoffMultiplier, long resetBackoffThresholdMS, double jitterFactor, int attemptsBeforeResetBackoff) {
            this.clock = clock;
            this.initialBackoffMS = initialBackoffMS;
            this.maxBackoffMS = maxBackoffMS;
            this.backoffMultiplier = backoffMultiplier;
            this.resetBackoffThresholdMS = resetBackoffThresholdMS;
            this.jitterFactor = jitterFactor;
            this.attemptsBeforeResetBackoff = attemptsBeforeResetBackoff;
        }

        @Override
        public RestartBackoffTimeStrategy create() {
            return new ExponentialDelayRestartBackoffTimeStrategy(this.clock, this.initialBackoffMS, this.maxBackoffMS, this.backoffMultiplier, this.resetBackoffThresholdMS, this.jitterFactor, this.attemptsBeforeResetBackoff);
        }
    }
}

