/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.execution;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public enum RestoreMode implements DescribedEnum
{
    CLAIM("Flink will take ownership of the given snapshot. It will clean the snapshot once it is subsumed by newer ones."),
    NO_CLAIM("Flink will not claim ownership of the snapshot files. However it will make sure it does not depend on any artefacts from the restored snapshot. In order to do that, Flink will take the first checkpoint as a full one, which means it might reupload/duplicate files that are part of the restored checkpoint."),
    LEGACY("This is the mode in which Flink worked until 1.15. It will not claim ownership of the snapshot and will not delete the files. However, it can directly depend on the existence of the files of the restored checkpoint. It might not be safe to delete checkpoints that were restored in legacy mode. This mode is deprecated, please use CLAIM or NO_CLAIM mode to get a clear state file ownership.");

    private final String description;
    public static final RestoreMode DEFAULT;

    private RestoreMode(String description) {
        this.description = description;
    }

    @Override
    @Internal
    public InlineElement getDescription() {
        return TextElement.text(this.description);
    }

    static {
        DEFAULT = NO_CLAIM;
    }
}

