/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogChange;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterOperation;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class AlterCatalogCommentOperation
implements AlterOperation {
    private final String catalogName;
    private final String comment;

    public AlterCatalogCommentOperation(String catalogName, String comment) {
        this.catalogName = Preconditions.checkNotNull(catalogName);
        this.comment = comment;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER CATALOG %s COMMENT '%s'", this.catalogName, EncodingUtils.escapeSingleQuotes(this.comment));
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getCatalogManager().alterCatalog(this.catalogName, new CatalogChange.CatalogCommentChange(this.comment));
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (CatalogException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

