/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class StateDescriptor<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String stateId;
    @Nonnull
    private final TypeSerializer<T> typeSerializer;
    @Nonnull
    private StateTtlConfig ttlConfig = StateTtlConfig.DISABLED;

    protected StateDescriptor(@Nonnull String stateId, TypeInformation<T> typeInfo) {
        this(stateId, typeInfo, new SerializerConfigImpl());
    }

    protected StateDescriptor(@Nonnull String stateId, @Nonnull TypeInformation<T> typeInfo, SerializerConfig serializerConfig) {
        this.stateId = Preconditions.checkNotNull(stateId, "stateId must not be null");
        Preconditions.checkNotNull(typeInfo, "type information must not be null");
        this.typeSerializer = typeInfo.createSerializer(serializerConfig);
    }

    public void enableTimeToLive(StateTtlConfig ttlConfig) {
        this.ttlConfig = Preconditions.checkNotNull(ttlConfig);
    }

    @Nonnull
    public StateTtlConfig getTtlConfig() {
        return this.ttlConfig;
    }

    @Nonnull
    public String getStateId() {
        return this.stateId;
    }

    @Nonnull
    public TypeSerializer<T> getSerializer() {
        return this.typeSerializer.duplicate();
    }

    public int hashCode() {
        return this.stateId.hashCode() + 31 * this.getClass().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            StateDescriptor that = (StateDescriptor)o;
            return this.stateId.equals(that.stateId);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stateId=" + this.stateId + ", typeSerializer=" + this.typeSerializer + ", ttlConfig=" + this.ttlConfig + '}';
    }

    public abstract Type getType();

    public static enum Type {
        VALUE,
        LIST,
        REDUCING,
        AGGREGATING,
        MAP;

    }
}

