/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.scalingpolicy;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.scheduler.adaptive.scalingpolicy.RescalingController;

public class EnforceMinimalIncreaseRescalingController
implements RescalingController {
    private final int minParallelismIncrease;

    public EnforceMinimalIncreaseRescalingController(Configuration configuration) {
        this.minParallelismIncrease = configuration.get(JobManagerOptions.MIN_PARALLELISM_INCREASE);
    }

    @Override
    public boolean shouldRescale(VertexParallelism currentParallelism, VertexParallelism newParallelism) {
        for (JobVertexID vertex : currentParallelism.getVertices()) {
            int parallelismChange = newParallelism.getParallelism(vertex) - currentParallelism.getParallelism(vertex);
            if (parallelismChange >= 0 && parallelismChange < this.minParallelismIncrease) continue;
            return true;
        }
        return false;
    }
}

