/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.rest.messages.json.JobIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobIDSerializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.runtime.rest.messages.json.SlotSharingGroupIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.SlotSharingGroupIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class JobDetailsInfo
implements ResponseBody {
    public static final String FIELD_NAME_JOB_ID = "jid";
    public static final String FIELD_NAME_JOB_NAME = "name";
    public static final String FIELD_NAME_IS_STOPPABLE = "isStoppable";
    public static final String FIELD_NAME_JOB_STATUS = "state";
    public static final String FIELD_NAME_JOB_TYPE = "job-type";
    public static final String FIELD_NAME_START_TIME = "start-time";
    public static final String FIELD_NAME_END_TIME = "end-time";
    public static final String FIELD_NAME_DURATION = "duration";
    public static final String FIELD_NAME_MAX_PARALLELISM = "maxParallelism";
    public static final String FIELD_NAME_NOW = "now";
    public static final String FIELD_NAME_TIMESTAMPS = "timestamps";
    public static final String FIELD_NAME_JOB_VERTEX_INFOS = "vertices";
    public static final String FIELD_NAME_JOB_VERTICES_PER_STATE = "status-counts";
    public static final String FIELD_NAME_JSON_PLAN = "plan";
    @JsonProperty(value="jid")
    @JsonSerialize(using=JobIDSerializer.class)
    private final JobID jobId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="isStoppable")
    private final boolean isStoppable;
    @JsonProperty(value="state")
    private final JobStatus jobStatus;
    @JsonProperty(value="job-type")
    private final JobType jobType;
    @JsonProperty(value="start-time")
    private final long startTime;
    @JsonProperty(value="end-time")
    private final long endTime;
    @JsonProperty(value="duration")
    private final long duration;
    @JsonProperty(value="maxParallelism")
    private final long maxParallelism;
    @JsonProperty(value="now")
    private final long now;
    @JsonProperty(value="timestamps")
    private final Map<JobStatus, Long> timestamps;
    @JsonProperty(value="vertices")
    private final Collection<JobVertexDetailsInfo> jobVertexInfos;
    @JsonProperty(value="status-counts")
    private final Map<ExecutionState, Integer> jobVerticesPerState;
    @JsonProperty(value="plan")
    private final JobPlanInfo.RawJson jsonPlan;

    @JsonCreator
    public JobDetailsInfo(@JsonDeserialize(using=JobIDDeserializer.class) @JsonProperty(value="jid") JobID jobId, @JsonProperty(value="name") String name, @JsonProperty(value="isStoppable") boolean isStoppable, @JsonProperty(value="state") JobStatus jobStatus, @JsonProperty(value="job-type") JobType jobType, @JsonProperty(value="start-time") long startTime, @JsonProperty(value="end-time") long endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="maxParallelism") long maxParallelism, @JsonProperty(value="now") long now, @JsonProperty(value="timestamps") Map<JobStatus, Long> timestamps, @JsonProperty(value="vertices") Collection<JobVertexDetailsInfo> jobVertexInfos, @JsonProperty(value="status-counts") Map<ExecutionState, Integer> jobVerticesPerState, @JsonProperty(value="plan") JobPlanInfo.RawJson jsonPlan) {
        this.jobId = Preconditions.checkNotNull(jobId);
        this.name = Preconditions.checkNotNull(name);
        this.isStoppable = isStoppable;
        this.jobStatus = Preconditions.checkNotNull(jobStatus);
        this.jobType = Preconditions.checkNotNull(jobType);
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.maxParallelism = maxParallelism;
        this.now = now;
        this.timestamps = Preconditions.checkNotNull(timestamps);
        this.jobVertexInfos = Preconditions.checkNotNull(jobVertexInfos);
        this.jobVerticesPerState = Preconditions.checkNotNull(jobVerticesPerState);
        this.jsonPlan = Preconditions.checkNotNull(jsonPlan);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDetailsInfo that = (JobDetailsInfo)o;
        return this.isStoppable == that.isStoppable && this.startTime == that.startTime && this.endTime == that.endTime && this.duration == that.duration && this.maxParallelism == that.maxParallelism && this.now == that.now && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.name, that.name) && this.jobStatus == that.jobStatus && this.jobType == that.jobType && Objects.equals(this.timestamps, that.timestamps) && Objects.equals(this.jobVertexInfos, that.jobVertexInfos) && Objects.equals(this.jobVerticesPerState, that.jobVerticesPerState) && Objects.equals(this.jsonPlan, that.jsonPlan);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.name, this.isStoppable, this.jobStatus, this.jobType, this.startTime, this.endTime, this.duration, this.maxParallelism, this.now, this.timestamps, this.jobVertexInfos, this.jobVerticesPerState, this.jsonPlan});
    }

    @JsonIgnore
    public JobID getJobId() {
        return this.jobId;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public boolean isStoppable() {
        return this.isStoppable;
    }

    @JsonIgnore
    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    @JsonIgnore
    public JobType getJobType() {
        return this.jobType;
    }

    @JsonIgnore
    public long getStartTime() {
        return this.startTime;
    }

    @JsonIgnore
    public long getEndTime() {
        return this.endTime;
    }

    @JsonIgnore
    public long getMaxParallelism() {
        return this.maxParallelism;
    }

    @JsonIgnore
    public long getDuration() {
        return this.duration;
    }

    @JsonIgnore
    public long getNow() {
        return this.now;
    }

    @JsonIgnore
    public Map<JobStatus, Long> getTimestamps() {
        return this.timestamps;
    }

    @JsonIgnore
    public Collection<JobVertexDetailsInfo> getJobVertexInfos() {
        return this.jobVertexInfos;
    }

    @JsonIgnore
    public Map<ExecutionState, Integer> getJobVerticesPerState() {
        return this.jobVerticesPerState;
    }

    @JsonIgnore
    public String getJsonPlan() {
        return this.jsonPlan.toString();
    }

    @Schema(name="JobDetailsVertexInfo")
    public static final class JobVertexDetailsInfo {
        public static final String FIELD_NAME_JOB_VERTEX_ID = "id";
        public static final String FIELD_NAME_SLOT_SHARING_GROUP_ID = "slotSharingGroupId";
        public static final String FIELD_NAME_JOB_VERTEX_NAME = "name";
        public static final String FIELD_NAME_MAX_PARALLELISM = "maxParallelism";
        public static final String FIELD_NAME_PARALLELISM = "parallelism";
        public static final String FIELD_NAME_JOB_VERTEX_STATE = "status";
        public static final String FIELD_NAME_JOB_VERTEX_START_TIME = "start-time";
        public static final String FIELD_NAME_JOB_VERTEX_END_TIME = "end-time";
        public static final String FIELD_NAME_JOB_VERTEX_DURATION = "duration";
        public static final String FIELD_NAME_TASKS_PER_STATE = "tasks";
        public static final String FIELD_NAME_JOB_VERTEX_METRICS = "metrics";
        @JsonProperty(value="id")
        @JsonSerialize(using=JobVertexIDSerializer.class)
        private final JobVertexID jobVertexID;
        @JsonProperty(value="slotSharingGroupId")
        @JsonSerialize(using=SlotSharingGroupIDSerializer.class)
        private final SlotSharingGroupId slotSharingGroupId;
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="maxParallelism")
        private final int maxParallelism;
        @JsonProperty(value="parallelism")
        private final int parallelism;
        @JsonProperty(value="status")
        private final ExecutionState executionState;
        @JsonProperty(value="start-time")
        private final long startTime;
        @JsonProperty(value="end-time")
        private final long endTime;
        @JsonProperty(value="duration")
        private final long duration;
        @JsonProperty(value="tasks")
        private final Map<ExecutionState, Integer> tasksPerState;
        @JsonProperty(value="metrics")
        private final IOMetricsInfo jobVertexMetrics;

        @JsonCreator
        public JobVertexDetailsInfo(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="id") JobVertexID jobVertexID, @JsonDeserialize(using=SlotSharingGroupIDDeserializer.class) @JsonProperty(value="slotSharingGroupId") SlotSharingGroupId slotSharingGroupId, @JsonProperty(value="name") String name, @JsonProperty(value="maxParallelism") int maxParallelism, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="status") ExecutionState executionState, @JsonProperty(value="start-time") long startTime, @JsonProperty(value="end-time") long endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="tasks") Map<ExecutionState, Integer> tasksPerState, @JsonProperty(value="metrics") IOMetricsInfo jobVertexMetrics) {
            this.jobVertexID = Preconditions.checkNotNull(jobVertexID);
            this.slotSharingGroupId = Preconditions.checkNotNull(slotSharingGroupId);
            this.name = Preconditions.checkNotNull(name);
            this.maxParallelism = maxParallelism;
            this.parallelism = parallelism;
            this.executionState = Preconditions.checkNotNull(executionState);
            this.startTime = startTime;
            this.endTime = endTime;
            this.duration = duration;
            this.tasksPerState = Preconditions.checkNotNull(tasksPerState);
            this.jobVertexMetrics = Preconditions.checkNotNull(jobVertexMetrics);
        }

        @JsonIgnore
        public JobVertexID getJobVertexID() {
            return this.jobVertexID;
        }

        @JsonIgnore
        public SlotSharingGroupId getSlotSharingGroupId() {
            return this.slotSharingGroupId;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public int getMaxParallelism() {
            return this.maxParallelism;
        }

        @JsonIgnore
        public int getParallelism() {
            return this.parallelism;
        }

        @JsonIgnore
        public ExecutionState getExecutionState() {
            return this.executionState;
        }

        @JsonIgnore
        public long getStartTime() {
            return this.startTime;
        }

        @JsonIgnore
        public long getEndTime() {
            return this.endTime;
        }

        @JsonIgnore
        public long getDuration() {
            return this.duration;
        }

        @JsonIgnore
        public Map<ExecutionState, Integer> getTasksPerState() {
            return this.tasksPerState;
        }

        @JsonIgnore
        public IOMetricsInfo getJobVertexMetrics() {
            return this.jobVertexMetrics;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobVertexDetailsInfo that = (JobVertexDetailsInfo)o;
            return this.maxParallelism == that.maxParallelism && this.parallelism == that.parallelism && this.startTime == that.startTime && this.endTime == that.endTime && this.duration == that.duration && Objects.equals(this.jobVertexID, that.jobVertexID) && Objects.equals(this.slotSharingGroupId, that.slotSharingGroupId) && Objects.equals(this.name, that.name) && this.executionState == that.executionState && Objects.equals(this.tasksPerState, that.tasksPerState) && Objects.equals(this.jobVertexMetrics, that.jobVertexMetrics);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobVertexID, this.slotSharingGroupId, this.name, this.maxParallelism, this.parallelism, this.executionState, this.startTime, this.endTime, this.duration, this.tasksPerState, this.jobVertexMetrics});
        }
    }
}

