/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotInfoTracker;
import org.apache.flink.util.Preconditions;

public class DefaultFreeSlotInfoTracker
implements FreeSlotInfoTracker {
    private final Set<AllocationID> freeSlots;
    private final Function<AllocationID, SlotInfo> slotInfoLookup;
    private final Function<AllocationID, AllocatedSlotPool.FreeSlotInfo> freeSlotInfoLookup;
    private final Function<ResourceID, Double> taskExecutorUtilizationLookup;

    public DefaultFreeSlotInfoTracker(Set<AllocationID> freeSlots, Function<AllocationID, SlotInfo> slotInfoLookup, Function<AllocationID, AllocatedSlotPool.FreeSlotInfo> freeSlotInfoLookup, Function<ResourceID, Double> taskExecutorUtilizationLookup) {
        this.freeSlots = new HashSet<AllocationID>(freeSlots);
        this.slotInfoLookup = slotInfoLookup;
        this.freeSlotInfoLookup = freeSlotInfoLookup;
        this.taskExecutorUtilizationLookup = taskExecutorUtilizationLookup;
    }

    @Override
    public Set<AllocationID> getAvailableSlots() {
        return Collections.unmodifiableSet(this.freeSlots);
    }

    @Override
    public SlotInfo getSlotInfo(AllocationID allocationId) {
        return Preconditions.checkNotNull(this.slotInfoLookup.apply(allocationId));
    }

    @Override
    public Collection<AllocatedSlotPool.FreeSlotInfo> getFreeSlotsWithIdleSinceInformation() {
        return this.freeSlots.stream().map(this.freeSlotInfoLookup).collect(Collectors.toList());
    }

    @Override
    public Collection<SlotInfo> getFreeSlotsInformation() {
        return this.freeSlots.stream().map(this.slotInfoLookup).collect(Collectors.toList());
    }

    @Override
    public double getTaskExecutorUtilization(SlotInfo slotInfo) {
        ResourceID resourceId = slotInfo.getTaskManagerLocation().getResourceID();
        return this.taskExecutorUtilizationLookup.apply(resourceId);
    }

    @Override
    public void reserveSlot(AllocationID allocationId) {
        Preconditions.checkState(this.freeSlots.remove(allocationId), "Slot %s does not exist in free slots", allocationId);
    }

    @Override
    public DefaultFreeSlotInfoTracker createNewFreeSlotInfoTrackerWithoutBlockedSlots(Set<AllocationID> blockedSlots) {
        Set<AllocationID> freeSlotInfoTrackerWithoutBlockedSlots = this.freeSlots.stream().filter(slot -> !blockedSlots.contains(slot)).collect(Collectors.toSet());
        return new DefaultFreeSlotInfoTracker(freeSlotInfoTrackerWithoutBlockedSlots, this.slotInfoLookup, this.freeSlotInfoLookup, this.taskExecutorUtilizationLookup);
    }
}

