/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.shaded.guava31.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.apache.flink.util.Preconditions;

public class TieredStorageMemoryManagerImpl
implements TieredStorageMemoryManager {
    private static final int INITIAL_REQUEST_BUFFER_TIMEOUT_FOR_RECLAIMING_MS = 50;
    private static final int MAX_DELAY_TIME_TO_TRIGGER_RECLAIM_BUFFER_MS = 1000;
    private final Map<Object, TieredStorageMemorySpec> tieredMemorySpecs;
    private final List<Runnable> bufferReclaimRequestListeners;
    private final float numTriggerReclaimBuffersRatio;
    private final boolean mayReclaimBuffer;
    private final AtomicInteger numRequestedBuffers;
    private final Map<Object, Integer> numOwnerRequestedBuffers;
    private final BlockingQueue<MemorySegment> bufferQueue;
    private final ReadWriteLock releasedStateLock;
    private int numGuaranteedReclaimableBuffers;
    private TimerGauge hardBackpressureTimerGauge = new TimerGauge();
    @Nullable
    private ScheduledExecutorService executor;
    private BufferPool bufferPool;
    private boolean isInitialized;
    @GuardedBy(value="readWriteLock")
    private boolean isReleased;

    public TieredStorageMemoryManagerImpl(float numTriggerReclaimBuffersRatio, boolean mayReclaimBuffer) {
        this.numTriggerReclaimBuffersRatio = numTriggerReclaimBuffersRatio;
        this.mayReclaimBuffer = mayReclaimBuffer;
        this.tieredMemorySpecs = new HashMap<Object, TieredStorageMemorySpec>();
        this.numRequestedBuffers = new AtomicInteger(0);
        this.numOwnerRequestedBuffers = new ConcurrentHashMap<Object, Integer>();
        this.bufferReclaimRequestListeners = new ArrayList<Runnable>();
        this.bufferQueue = new LinkedBlockingQueue<MemorySegment>();
        this.releasedStateLock = new ReentrantReadWriteLock();
        this.isReleased = false;
        this.isInitialized = false;
    }

    @Override
    public void setup(BufferPool bufferPool, List<TieredStorageMemorySpec> storageMemorySpecs) {
        this.bufferPool = bufferPool;
        for (TieredStorageMemorySpec memorySpec : storageMemorySpecs) {
            Preconditions.checkState(!this.tieredMemorySpecs.containsKey(memorySpec.getOwner()), "Duplicated memory spec.");
            this.tieredMemorySpecs.put(memorySpec.getOwner(), memorySpec);
            this.numGuaranteedReclaimableBuffers += memorySpec.isGuaranteedReclaimable() ? memorySpec.getNumGuaranteedBuffers() : 0;
        }
        if (this.mayReclaimBuffer) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("buffer reclaim checker").setUncaughtExceptionHandler(FatalExitExceptionHandler.INSTANCE).build());
        }
        this.isInitialized = true;
    }

    @Override
    public void setMetricGroup(TaskIOMetricGroup metricGroup) {
        this.hardBackpressureTimerGauge = Preconditions.checkNotNull(metricGroup.getHardBackPressuredTimePerSecond());
    }

    @Override
    public void listenBufferReclaimRequest(Runnable onBufferReclaimRequest) {
        this.bufferReclaimRequestListeners.add(onBufferReclaimRequest);
    }

    @Override
    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public BufferBuilder requestBufferBlocking(Object owner) {
        this.checkIsInitialized();
        this.reclaimBuffersIfNeeded(0L);
        MemorySegment memorySegment = (MemorySegment)this.bufferQueue.poll();
        if (memorySegment == null) {
            memorySegment = this.requestBufferBlockingFromPool();
        }
        if (memorySegment == null) {
            memorySegment = Preconditions.checkNotNull(this.requestBufferBlockingFromQueue());
        }
        this.incNumRequestedBuffer(owner);
        return new BufferBuilder(Preconditions.checkNotNull(memorySegment), segment -> this.recycleBuffer(owner, segment));
    }

    @Override
    public int getMaxNonReclaimableBuffers(Object owner) {
        this.checkIsInitialized();
        int numBuffersUsedOrReservedForOtherOwners = 0;
        for (Map.Entry<Object, TieredStorageMemorySpec> memorySpecEntry : this.tieredMemorySpecs.entrySet()) {
            Object userOwner = memorySpecEntry.getKey();
            TieredStorageMemorySpec storageMemorySpec = memorySpecEntry.getValue();
            if (userOwner.equals(owner)) continue;
            int numGuaranteed = storageMemorySpec.getNumGuaranteedBuffers();
            int numRequested = this.numOwnerRequestedBuffer(userOwner);
            numBuffersUsedOrReservedForOtherOwners += Math.max(numGuaranteed, numRequested);
        }
        return this.bufferPool.getNumBuffers() - numBuffersUsedOrReservedForOtherOwners;
    }

    @Override
    public boolean ensureCapacity(int numAdditionalBuffers) {
        this.checkIsInitialized();
        int numRequestedByGuaranteedReclaimableOwners = this.tieredMemorySpecs.values().stream().filter(TieredStorageMemorySpec::isGuaranteedReclaimable).mapToInt(spec -> this.numOwnerRequestedBuffer(spec.getOwner())).sum();
        while (this.bufferQueue.size() + numRequestedByGuaranteedReclaimableOwners < this.numGuaranteedReclaimableBuffers + numAdditionalBuffers) {
            if (this.numRequestedBuffers.get() >= this.bufferPool.getNumBuffers()) {
                return false;
            }
            MemorySegment memorySegment = this.requestBufferBlockingFromPool();
            if (memorySegment == null) {
                return false;
            }
            this.bufferQueue.add(memorySegment);
        }
        return true;
    }

    @Override
    public int numOwnerRequestedBuffer(Object owner) {
        return this.numOwnerRequestedBuffers.getOrDefault(owner, 0);
    }

    @Override
    public void transferBufferOwnership(Object oldOwner, Object newOwner, Buffer buffer) {
        Preconditions.checkState(buffer.isBuffer(), "Only buffer supports transfer ownership.");
        this.decNumRequestedBuffer(oldOwner);
        this.incNumRequestedBuffer(newOwner);
        buffer.setRecycler(memorySegment -> this.recycleBuffer(newOwner, memorySegment));
    }

    @Override
    public void release() {
        try {
            this.releasedStateLock.writeLock().lock();
            this.isReleased = true;
        }
        finally {
            this.releasedStateLock.writeLock().unlock();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new TimeoutException("Timeout for shutting down the buffer reclaim checker executor.");
                }
            }
            catch (Exception e) {
                ExceptionUtils.rethrow(e);
            }
        }
        while (!this.bufferQueue.isEmpty()) {
            MemorySegment segment = (MemorySegment)this.bufferQueue.poll();
            this.bufferPool.recycle(segment);
            this.numRequestedBuffers.decrementAndGet();
        }
    }

    @Nullable
    private MemorySegment requestBufferBlockingFromPool() {
        MemorySegment memorySegment = null;
        this.hardBackpressureTimerGauge.markStart();
        while (this.numRequestedBuffers.get() < this.bufferPool.getNumBuffers()) {
            memorySegment = this.bufferPool.requestMemorySegment();
            if (memorySegment == null) {
                try {
                    this.bufferPool.getAvailableFuture().get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (Exception e) {
                    ExceptionUtils.rethrow(e);
                }
                continue;
            }
            this.numRequestedBuffers.incrementAndGet();
            break;
        }
        this.hardBackpressureTimerGauge.markEnd();
        return memorySegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemorySegment requestBufferBlockingFromQueue() {
        CompletableFuture<Void> requestBufferFuture = new CompletableFuture<Void>();
        this.scheduleCheckRequestBufferFuture(requestBufferFuture, 50L);
        MemorySegment memorySegment = null;
        try {
            memorySegment = this.bufferQueue.take();
        }
        catch (InterruptedException e) {
            ExceptionUtils.rethrow(e);
        }
        finally {
            requestBufferFuture.complete(null);
        }
        return memorySegment;
    }

    private void scheduleCheckRequestBufferFuture(CompletableFuture<Void> requestBufferFuture, long delayMs) {
        if (!this.mayReclaimBuffer || requestBufferFuture.isDone()) {
            return;
        }
        Preconditions.checkNotNull(this.executor).schedule(() -> this.internalCheckRequestBufferFuture(requestBufferFuture, delayMs * 2L), delayMs, TimeUnit.MILLISECONDS);
    }

    private void internalCheckRequestBufferFuture(CompletableFuture<Void> requestBufferFuture, long delayForNextCheckMs) {
        if (requestBufferFuture.isDone()) {
            return;
        }
        this.reclaimBuffersIfNeeded(delayForNextCheckMs);
        this.scheduleCheckRequestBufferFuture(requestBufferFuture, delayForNextCheckMs);
    }

    private void incNumRequestedBuffer(Object owner) {
        this.numOwnerRequestedBuffers.compute(owner, (ignore, numRequested) -> numRequested == null ? 1 : numRequested + 1);
    }

    private void decNumRequestedBuffer(Object owner) {
        this.numOwnerRequestedBuffers.compute(owner, (ignore, numRequested) -> Preconditions.checkNotNull(numRequested) - 1);
    }

    private void reclaimBuffersIfNeeded(long delayForNextCheckMs) {
        if (this.shouldReclaimBuffersBeforeRequesting(delayForNextCheckMs)) {
            this.bufferReclaimRequestListeners.forEach(Runnable::run);
        }
    }

    private boolean shouldReclaimBuffersBeforeRequesting(long delayForNextCheckMs) {
        int numTotal = this.bufferPool.getNumBuffers();
        int numRequested = this.numRequestedBuffers.get();
        return (double)(numRequested + 1 - this.bufferQueue.size()) * 1.0 / (double)numTotal > (double)this.numTriggerReclaimBuffersRatio || delayForNextCheckMs > 1000L && this.bufferQueue.size() == 0;
    }

    private void recycleBuffer(Object owner, MemorySegment buffer) {
        try {
            this.releasedStateLock.readLock().lock();
            if (!this.isReleased && this.numRequestedBuffers.get() <= this.bufferPool.getNumBuffers()) {
                this.bufferQueue.add(buffer);
            } else {
                this.bufferPool.recycle(buffer);
                this.numRequestedBuffers.decrementAndGet();
            }
        }
        finally {
            this.releasedStateLock.readLock().unlock();
        }
        this.decNumRequestedBuffer(owner);
    }

    private void checkIsInitialized() {
        Preconditions.checkState(this.isInitialized, "The memory manager is not in the running state.");
    }
}

