/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionedFileReader;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

class SortMergeSubpartitionReader
implements ResultSubpartitionView,
Comparable<SortMergeSubpartitionReader> {
    private final Object lock = new Object();
    private final CompletableFuture<?> releaseFuture = new CompletableFuture();
    private final BufferAvailabilityListener availabilityListener;
    @GuardedBy(value="lock")
    private final Queue<Buffer> buffersRead = new ArrayDeque<Buffer>();
    private final PartitionedFileReader fileReader;
    @GuardedBy(value="lock")
    private int dataBufferBacklog;
    @GuardedBy(value="lock")
    private boolean isReleased;
    @GuardedBy(value="lock")
    private Throwable failureCause;
    private int sequenceNumber;

    SortMergeSubpartitionReader(BufferAvailabilityListener listener, PartitionedFileReader fileReader) {
        this.availabilityListener = Preconditions.checkNotNull(listener);
        this.fileReader = Preconditions.checkNotNull(fileReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() {
        Object object = this.lock;
        synchronized (object) {
            Buffer lookAhead;
            Buffer buffer = this.buffersRead.poll();
            if (buffer == null) {
                return null;
            }
            if (buffer.isBuffer()) {
                --this.dataBufferBacklog;
            }
            Buffer.DataType dataType = (lookAhead = this.buffersRead.peek()) == null ? Buffer.DataType.NONE : lookAhead.getDataType();
            return ResultSubpartition.BufferAndBacklog.fromBufferAndLookahead(buffer, dataType, this.dataBufferBacklog, this.sequenceNumber++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuffer(Buffer buffer) {
        boolean notifyAvailable = false;
        boolean needRecycleBuffer = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased) {
                needRecycleBuffer = true;
            } else {
                notifyAvailable = this.buffersRead.isEmpty();
                this.buffersRead.add(buffer);
                if (buffer.isBuffer()) {
                    ++this.dataBufferBacklog;
                }
            }
        }
        if (needRecycleBuffer) {
            buffer.recycleBuffer();
            throw new IllegalStateException("Subpartition reader has been already released.");
        }
        if (notifyAvailable) {
            this.notifyDataAvailable();
        }
    }

    boolean readBuffers(Queue<MemorySegment> buffers, BufferRecycler recycler) throws IOException {
        return this.fileReader.readCurrentRegion(buffers, recycler, this::addBuffer);
    }

    CompletableFuture<?> getReleaseFuture() {
        return this.releaseFuture;
    }

    void fail(Throwable throwable) {
        Preconditions.checkArgument(throwable != null, "Must be not null.");
        this.releaseInternal(throwable);
        this.notifyDataAvailable();
    }

    @Override
    public void notifyDataAvailable() {
        this.availabilityListener.notifyDataAvailable(this);
    }

    @Override
    public int compareTo(SortMergeSubpartitionReader that) {
        long thatPriority;
        int thatQueuedBuffers;
        int thisQueuedBuffers = this.unsynchronizedGetNumberOfQueuedBuffers();
        if (thisQueuedBuffers != (thatQueuedBuffers = that.unsynchronizedGetNumberOfQueuedBuffers()) && (thisQueuedBuffers == 0 || thatQueuedBuffers == 0)) {
            return thisQueuedBuffers > thatQueuedBuffers ? 1 : -1;
        }
        long thisPriority = this.fileReader.getPriority();
        if (thisPriority == (thatPriority = that.fileReader.getPriority())) {
            return 0;
        }
        return thisPriority > thatPriority ? 1 : -1;
    }

    @Override
    public void releaseAllResources() {
        this.releaseInternal(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal(@Nullable Throwable throwable) {
        ArrayList<Buffer> buffersToRecycle;
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased) {
                return;
            }
            this.isReleased = true;
            if (this.failureCause == null) {
                this.failureCause = throwable;
            }
            buffersToRecycle = new ArrayList<Buffer>(this.buffersRead);
            this.buffersRead.clear();
            this.dataBufferBacklog = 0;
        }
        buffersToRecycle.forEach(Buffer::recycleBuffer);
        buffersToRecycle.clear();
        this.releaseFuture.complete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReleased() {
        Object object = this.lock;
        synchronized (object) {
            return this.isReleased;
        }
    }

    @Override
    public void resumeConsumption() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public void acknowledgeAllDataProcessed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Throwable getFailureCause() {
        Object object = this.lock;
        synchronized (object) {
            return this.failureCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog(boolean isCreditAvailable) {
        Object object = this.lock;
        synchronized (object) {
            boolean isAvailable = this.isReleased ? true : (this.buffersRead.isEmpty() ? false : isCreditAvailable || !this.buffersRead.peek().isBuffer());
            return new ResultSubpartitionView.AvailabilityWithBacklog(isAvailable, this.dataBufferBacklog);
        }
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return this.buffersRead.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfQueuedBuffers() {
        Object object = this.lock;
        synchronized (object) {
            return this.buffersRead.size();
        }
    }

    @Override
    public void notifyNewBufferSize(int newBufferSize) {
    }

    @Override
    public int peekNextBufferSubpartitionId() {
        throw new UnsupportedOperationException();
    }
}

