/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateCheckpointWriter;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.CheckpointInProgressRequestState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

final class CheckpointInProgressRequest
extends ChannelStateWriteRequest {
    private final ThrowingConsumer<ChannelStateCheckpointWriter, Exception> action;
    private final ThrowingConsumer<Throwable, Exception> discardAction;
    private final AtomicReference<CheckpointInProgressRequestState> state = new AtomicReference<CheckpointInProgressRequestState>(CheckpointInProgressRequestState.NEW);
    @Nullable
    private final CompletableFuture<?> readyFuture;

    CheckpointInProgressRequest(String name, JobVertexID jobVertexID, int subtaskIndex, long checkpointId, ThrowingConsumer<ChannelStateCheckpointWriter, Exception> action) {
        this(name, jobVertexID, subtaskIndex, checkpointId, action, unused -> {});
    }

    CheckpointInProgressRequest(String name, JobVertexID jobVertexID, int subtaskIndex, long checkpointId, ThrowingConsumer<ChannelStateCheckpointWriter, Exception> action, ThrowingConsumer<Throwable, Exception> discardAction) {
        this(name, jobVertexID, subtaskIndex, checkpointId, action, discardAction, null);
    }

    CheckpointInProgressRequest(String name, JobVertexID jobVertexID, int subtaskIndex, long checkpointId, ThrowingConsumer<ChannelStateCheckpointWriter, Exception> action, ThrowingConsumer<Throwable, Exception> discardAction, @Nullable CompletableFuture<?> readyFuture) {
        super(jobVertexID, subtaskIndex, checkpointId, name);
        this.action = Preconditions.checkNotNull(action);
        this.discardAction = Preconditions.checkNotNull(discardAction);
        this.readyFuture = readyFuture;
    }

    @Override
    public void cancel(Throwable cause) throws Exception {
        if (this.state.compareAndSet(CheckpointInProgressRequestState.NEW, CheckpointInProgressRequestState.CANCELLED) || this.state.compareAndSet(CheckpointInProgressRequestState.FAILED, CheckpointInProgressRequestState.CANCELLED)) {
            this.discardAction.accept(cause);
        }
    }

    void execute(ChannelStateCheckpointWriter channelStateCheckpointWriter) throws Exception {
        Preconditions.checkState(this.state.compareAndSet(CheckpointInProgressRequestState.NEW, CheckpointInProgressRequestState.EXECUTING));
        try {
            this.action.accept(channelStateCheckpointWriter);
            this.state.set(CheckpointInProgressRequestState.COMPLETED);
        }
        catch (Exception e) {
            this.state.set(CheckpointInProgressRequestState.FAILED);
            throw e;
        }
    }

    @Override
    public CompletableFuture<?> getReadyFuture() {
        if (this.readyFuture != null) {
            return this.readyFuture;
        }
        return super.getReadyFuture();
    }
}

