/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterators;
import org.apache.flink.util.function.FunctionWithException;

public class ComponentClassLoader
extends URLClassLoader {
    private static final ClassLoader PLATFORM_OR_BOOTSTRAP_LOADER;
    private final ClassLoader ownerClassLoader;
    private final String[] ownerFirstPackages;
    private final String[] componentFirstPackages;
    private final String[] ownerFirstResourcePrefixes;
    private final String[] componentFirstResourcePrefixes;
    private final Map<String, String> knownPackagePrefixesModuleAssociation;

    public ComponentClassLoader(URL[] classpath, ClassLoader ownerClassLoader, String[] ownerFirstPackages, String[] componentFirstPackages, Map<String, String> knownPackagePrefixesModuleAssociation) {
        super(classpath, PLATFORM_OR_BOOTSTRAP_LOADER);
        this.ownerClassLoader = ownerClassLoader;
        this.ownerFirstPackages = ownerFirstPackages;
        this.componentFirstPackages = componentFirstPackages;
        this.knownPackagePrefixesModuleAssociation = knownPackagePrefixesModuleAssociation;
        this.ownerFirstResourcePrefixes = ComponentClassLoader.convertPackagePrefixesToPathPrefixes(ownerFirstPackages);
        this.componentFirstResourcePrefixes = ComponentClassLoader.convertPackagePrefixesToPathPrefixes(componentFirstPackages);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            try {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass != null) {
                    return this.resolveIfNeeded(resolve, loadedClass);
                }
                if (this.isComponentFirstClass(name)) {
                    return this.loadClassFromComponentFirst(name, resolve);
                }
                if (this.isOwnerFirstClass(name)) {
                    return this.loadClassFromOwnerFirst(name, resolve);
                }
                return this.loadClassFromComponentOnly(name, resolve);
            }
            catch (ClassNotFoundException e) {
                Optional<String> foundAssociatedModule = this.knownPackagePrefixesModuleAssociation.entrySet().stream().filter(entry -> name.startsWith((String)entry.getKey())).map(Map.Entry::getValue).findFirst();
                if (foundAssociatedModule.isPresent()) {
                    throw new ClassNotFoundException(String.format("Class '%s' not found. Perhaps you forgot to add the module '%s' to the classpath?", name, foundAssociatedModule.get()), e);
                }
                throw e;
            }
        }
    }

    private Class<?> resolveIfNeeded(boolean resolve, Class<?> loadedClass) {
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    private boolean isOwnerFirstClass(String name) {
        return Arrays.stream(this.ownerFirstPackages).anyMatch(name::startsWith);
    }

    private boolean isComponentFirstClass(String name) {
        return Arrays.stream(this.componentFirstPackages).anyMatch(name::startsWith);
    }

    private Class<?> loadClassFromComponentOnly(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    private Class<?> loadClassFromComponentFirst(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.loadClassFromComponentOnly(name, resolve);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return this.loadClassFromOwnerOnly(name, resolve);
        }
    }

    private Class<?> loadClassFromOwnerOnly(String name, boolean resolve) throws ClassNotFoundException {
        return this.resolveIfNeeded(resolve, this.ownerClassLoader.loadClass(name));
    }

    private Class<?> loadClassFromOwnerFirst(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.loadClassFromOwnerOnly(name, resolve);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return this.loadClassFromComponentOnly(name, resolve);
        }
    }

    @Override
    public URL getResource(String name) {
        try {
            Enumeration<URL> resources = this.getResources(name);
            if (resources.hasMoreElements()) {
                return resources.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.isComponentFirstClass(name)) {
            return super.getResourceAsStream(name);
        }
        if (this.isOwnerFirstClass(name)) {
            return this.ownerClassLoader.getResourceAsStream(name);
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isComponentFirstResource(name)) {
            return this.loadResourceFromComponentFirst(name);
        }
        if (this.isOwnerFirstResource(name)) {
            return this.loadResourceFromOwnerFirst(name);
        }
        return this.loadResourceFromComponentOnly(name);
    }

    private boolean isOwnerFirstResource(String name) {
        return Arrays.stream(this.ownerFirstResourcePrefixes).anyMatch(name::startsWith);
    }

    private boolean isComponentFirstResource(String name) {
        return Arrays.stream(this.componentFirstResourcePrefixes).anyMatch(name::startsWith);
    }

    private Enumeration<URL> loadResourceFromComponentOnly(String name) throws IOException {
        return super.getResources(name);
    }

    private Enumeration<URL> loadResourceFromComponentFirst(String name) throws IOException {
        return this.loadResourcesInOrder(name, this::loadResourceFromComponentOnly, this::loadResourceFromOwnerOnly);
    }

    private Enumeration<URL> loadResourceFromOwnerOnly(String name) throws IOException {
        return this.ownerClassLoader.getResources(name);
    }

    private Enumeration<URL> loadResourceFromOwnerFirst(String name) throws IOException {
        return this.loadResourcesInOrder(name, this::loadResourceFromOwnerOnly, this::loadResourceFromComponentOnly);
    }

    private Enumeration<URL> loadResourcesInOrder(String name, ResourceLoadingFunction firstClassLoader, ResourceLoadingFunction secondClassLoader) throws IOException {
        Iterator iterator = Iterators.concat(Iterators.forEnumeration((Enumeration)firstClassLoader.apply(name)), Iterators.forEnumeration((Enumeration)secondClassLoader.apply(name)));
        return new IteratorBackedEnumeration<URL>(iterator);
    }

    private static String[] convertPackagePrefixesToPathPrefixes(String[] packagePrefixes) {
        return (String[])Arrays.stream(packagePrefixes).map(packageName -> packageName.replace('.', '/')).toArray(String[]::new);
    }

    static {
        ClassLoader platformLoader = null;
        try {
            platformLoader = (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot retrieve platform classloader on Java 9+", e);
        }
        PLATFORM_OR_BOOTSTRAP_LOADER = platformLoader;
        ClassLoader.registerAsParallelCapable();
    }

    @VisibleForTesting
    static class IteratorBackedEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> backingIterator;

        public IteratorBackedEnumeration(Iterator<T> backingIterator) {
            this.backingIterator = backingIterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.backingIterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.backingIterator.next();
        }
    }

    private static interface ResourceLoadingFunction
    extends FunctionWithException<String, Enumeration<URL>, IOException> {
    }
}

