/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.operators.util.JoinHashMap;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.iterative.concurrent.SolutionSetBroker;
import org.apache.flink.runtime.iterative.task.AbstractIterativeTask;
import org.apache.flink.runtime.operators.ResettableDriver;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class JoinWithSolutionSetSecondDriver<IT1, IT2, OT>
implements ResettableDriver<FlatJoinFunction<IT1, IT2, OT>, OT> {
    private TaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> taskContext;
    private CompactingHashTable<IT2> hashTable;
    private JoinHashMap<IT2> objectMap;
    private TypeComparator<IT1> probeSideComparator;
    private TypePairComparator<IT1, IT2> pairComparator;
    private IT2 solutionSideRecord;
    private IT1 probeSideRecord;
    protected volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<FlatJoinFunction<IT1, IT2, OT>> getStubType() {
        Class<FlatJoinFunction> clazz = FlatJoinFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 1;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize() throws Exception {
        void var2_7;
        TypeSerializer<Object> solutionSetSerializer;
        if (!(this.taskContext instanceof AbstractIterativeTask)) throw new Exception("The task context of this driver is no iterative task context.");
        AbstractIterativeTask iterativeTaskContext = (AbstractIterativeTask)this.taskContext;
        String identifier = iterativeTaskContext.brokerKey();
        Object table = SolutionSetBroker.instance().get(identifier);
        if (table instanceof CompactingHashTable) {
            this.hashTable = (CompactingHashTable)table;
            solutionSetSerializer = this.hashTable.getBuildSideSerializer();
            TypeComparator typeComparator = this.hashTable.getBuildSideComparator().duplicate();
        } else {
            if (!(table instanceof JoinHashMap)) throw new RuntimeException("Unrecognized solution set index: " + table);
            this.objectMap = (JoinHashMap)((Object)table);
            solutionSetSerializer = this.objectMap.getBuildSerializer();
            TypeComparator<IT2> typeComparator = this.objectMap.getBuildComparator().duplicate();
        }
        TaskConfig config = this.taskContext.getTaskConfig();
        ClassLoader classLoader = this.taskContext.getUserCodeClassLoader();
        TypeSerializer probeSideSerializer = this.taskContext.getInputSerializer(0).getSerializer();
        TypeComparatorFactory probeSideComparatorFactory = config.getDriverComparator(0, classLoader);
        this.probeSideComparator = probeSideComparatorFactory.createComparator();
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (this.objectReuseEnabled) {
            this.solutionSideRecord = solutionSetSerializer.createInstance();
            this.probeSideRecord = probeSideSerializer.createInstance();
        }
        TypePairComparatorFactory factory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        this.pairComparator = factory.createComparator12(this.probeSideComparator, var2_7);
    }

    @Override
    public void prepare() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws Exception {
        FlatJoinFunction<IT1, IT2, OT> joinFunction = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        MutableObjectIterator probeSideInput = this.taskContext.getInput(0);
        if (this.objectReuseEnabled) {
            IT1 IT1 = this.probeSideRecord;
            if (this.hashTable != null) {
                void var4_5;
                void var4_6;
                CompactingHashTable<IT2> join = this.hashTable;
                AbstractHashTableProber prober = join.getProber(this.probeSideComparator, this.pairComparator);
                IT2 buildSideRecord = this.solutionSideRecord;
                while (this.running && (var4_6 = probeSideInput.next(var4_5)) != null) {
                    IT2 matchedRecord = ((CompactingHashTable.HashTableProber)prober).getMatchFor(var4_6, buildSideRecord);
                    joinFunction.join(var4_6, matchedRecord, collector);
                }
                return;
            } else {
                void var4_7;
                void var4_8;
                if (this.objectMap == null) throw new RuntimeException();
                JoinHashMap<IT2> hashTable = this.objectMap;
                JoinHashMap.Prober<IT1> prober = this.objectMap.createProber(this.probeSideComparator, this.pairComparator);
                TypeSerializer<IT2> buildSerializer = hashTable.getBuildSerializer();
                while (this.running && (var4_8 = probeSideInput.next(var4_7)) != null) {
                    Object match = prober.lookupMatch(var4_8);
                    joinFunction.join(var4_8, buildSerializer.copy(match), collector);
                }
            }
            return;
        } else if (this.hashTable != null) {
            Object x;
            CompactingHashTable<IT2> join = this.hashTable;
            AbstractHashTableProber prober = join.getProber(this.probeSideComparator, this.pairComparator);
            while (this.running && (x = probeSideInput.next()) != null) {
                Object buildSideRecord = ((CompactingHashTable.HashTableProber)prober).getMatchFor(x);
                joinFunction.join(x, buildSideRecord, collector);
            }
            return;
        } else {
            Object x;
            if (this.objectMap == null) throw new RuntimeException();
            JoinHashMap<IT2> hashTable = this.objectMap;
            JoinHashMap.Prober<IT1> prober = this.objectMap.createProber(this.probeSideComparator, this.pairComparator);
            TypeSerializer<IT2> buildSerializer = hashTable.getBuildSerializer();
            while (this.running && (x = probeSideInput.next()) != null) {
                Object match = prober.lookupMatch(x);
                joinFunction.join(x, buildSerializer.copy(match), collector);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

