/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.util.Preconditions;

public class JobMasterConfiguration {
    private final Time rpcTimeout;
    private final Time slotRequestTimeout;
    private final String tmpDirectory;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;
    private final Configuration configuration;

    public JobMasterConfiguration(Time rpcTimeout, Time slotRequestTimeout, String tmpDirectory, RetryingRegistrationConfiguration retryingRegistrationConfiguration, Configuration configuration) {
        this.rpcTimeout = Preconditions.checkNotNull(rpcTimeout);
        this.slotRequestTimeout = Preconditions.checkNotNull(slotRequestTimeout);
        this.tmpDirectory = Preconditions.checkNotNull(tmpDirectory);
        this.retryingRegistrationConfiguration = retryingRegistrationConfiguration;
        this.configuration = Preconditions.checkNotNull(configuration);
    }

    public Time getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Time getSlotRequestTimeout() {
        return this.slotRequestTimeout;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public RetryingRegistrationConfiguration getRetryingRegistrationConfiguration() {
        return this.retryingRegistrationConfiguration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static JobMasterConfiguration fromConfiguration(Configuration configuration) {
        Time rpcTimeout = Time.fromDuration(configuration.get(RpcOptions.ASK_TIMEOUT_DURATION));
        Time slotRequestTimeout = Time.milliseconds(configuration.get(JobManagerOptions.SLOT_REQUEST_TIMEOUT));
        String tmpDirectory = ConfigurationUtils.parseTempDirectories(configuration)[0];
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration(configuration);
        return new JobMasterConfiguration(rpcTimeout, slotRequestTimeout, tmpDirectory, retryingRegistrationConfiguration, configuration);
    }
}

