/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.lang.reflect.Field;
import java.util.Optional;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.PooledByteBufAllocator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyBufferPool
extends PooledByteBufAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(NettyBufferPool.class);
    private final Object[] directArenas;
    private final int numberOfArenas;
    private final int chunkSize;
    private static final boolean PREFER_DIRECT = true;
    private static final int PAGE_SIZE = 8192;
    private static final int MAX_ORDER = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyBufferPool(int numberOfArenas) {
        super(true, 0, numberOfArenas, 8192, 9);
        Preconditions.checkArgument(numberOfArenas >= 1, "Number of arenas");
        this.numberOfArenas = numberOfArenas;
        this.chunkSize = 0x400000;
        Object[] allocDirectArenas = null;
        try {
            Field directArenasField = PooledByteBufAllocator.class.getDeclaredField("directArenas");
            directArenasField.setAccessible(true);
            allocDirectArenas = (Object[])directArenasField.get(this);
        }
        catch (Exception ignored) {
            LOG.warn("Memory statistics not available");
        }
        finally {
            this.directArenas = allocDirectArenas;
        }
    }

    int getNumberOfArenas() {
        return this.numberOfArenas;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    public Optional<Long> getNumberOfAllocatedBytes() throws NoSuchFieldException, IllegalAccessException {
        if (this.directArenas != null) {
            long numChunks = 0L;
            for (Object arena : this.directArenas) {
                numChunks += this.getNumberOfAllocatedChunks(arena, "qInit");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q000");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q025");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q050");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q075");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q100");
            }
            long allocatedBytes = numChunks * (long)this.chunkSize;
            return Optional.of(allocatedBytes);
        }
        return Optional.empty();
    }

    private long getNumberOfAllocatedChunks(Object arena, String chunkListFieldName) throws NoSuchFieldException, IllegalAccessException {
        Field chunkListField = arena.getClass().getSuperclass().getDeclaredField(chunkListFieldName);
        chunkListField.setAccessible(true);
        Object chunkList = chunkListField.get(arena);
        Field headChunkField = chunkList.getClass().getDeclaredField("head");
        headChunkField.setAccessible(true);
        Object headChunk = headChunkField.get(chunkList);
        if (headChunk == null) {
            return 0L;
        }
        int numChunks = 0;
        Object current = headChunk;
        while (current != null) {
            Field nextChunkField = headChunk.getClass().getDeclaredField("next");
            nextChunkField.setAccessible(true);
            current = nextChunkField.get(current);
            ++numChunks;
        }
        return numChunks;
    }

    @Override
    public ByteBuf heapBuffer() {
        return this.directBuffer();
    }

    @Override
    public ByteBuf heapBuffer(int initialCapacity) {
        return this.directBuffer(initialCapacity);
    }

    @Override
    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return this.directBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        return this.compositeDirectBuffer();
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return this.compositeDirectBuffer(maxNumComponents);
    }
}

