/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulk;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

class SharingPhysicalSlotRequestBulk
implements PhysicalSlotRequestBulk {
    private final Map<ExecutionSlotSharingGroup, List<ExecutionVertexID>> executions;
    private final Map<ExecutionSlotSharingGroup, ResourceProfile> pendingRequests;
    private final Map<ExecutionSlotSharingGroup, AllocationID> fulfilledRequests;
    private final BiConsumer<ExecutionVertexID, Throwable> logicalSlotRequestCanceller;

    SharingPhysicalSlotRequestBulk(Map<ExecutionSlotSharingGroup, List<ExecutionVertexID>> executions, Map<ExecutionSlotSharingGroup, ResourceProfile> pendingRequests, BiConsumer<ExecutionVertexID, Throwable> logicalSlotRequestCanceller) {
        this.executions = Preconditions.checkNotNull(executions);
        this.pendingRequests = Preconditions.checkNotNull(pendingRequests);
        this.fulfilledRequests = new HashMap<ExecutionSlotSharingGroup, AllocationID>();
        this.logicalSlotRequestCanceller = Preconditions.checkNotNull(logicalSlotRequestCanceller);
    }

    @Override
    public Collection<ResourceProfile> getPendingRequests() {
        return this.pendingRequests.values();
    }

    @Override
    public Set<AllocationID> getAllocationIdsOfFulfilledRequests() {
        return new HashSet<AllocationID>(this.fulfilledRequests.values());
    }

    @Override
    public void cancel(Throwable cause) {
        for (ExecutionSlotSharingGroup group : this.pendingRequests.keySet()) {
            for (ExecutionVertexID id : this.executions.get(group)) {
                this.logicalSlotRequestCanceller.accept(id, cause);
            }
        }
        for (ExecutionSlotSharingGroup group : this.fulfilledRequests.keySet()) {
            for (ExecutionVertexID id : this.executions.get(group)) {
                this.logicalSlotRequestCanceller.accept(id, cause);
            }
        }
    }

    void markFulfilled(ExecutionSlotSharingGroup group, AllocationID allocationId) {
        this.pendingRequests.remove(group);
        this.fulfilledRequests.put(group, allocationId);
    }

    void clearPendingRequests() {
        this.pendingRequests.clear();
    }
}

