/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.highavailability.ClientHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.util.Preconditions;

public class ZooKeeperClientHAServices
implements ClientHighAvailabilityServices {
    private final CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;
    private final Configuration configuration;

    public ZooKeeperClientHAServices(@Nonnull CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper, @Nonnull Configuration configuration) {
        this.curatorFrameworkWrapper = Preconditions.checkNotNull(curatorFrameworkWrapper);
        this.configuration = Preconditions.checkNotNull(configuration);
    }

    @Override
    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        return ZooKeeperUtils.createLeaderRetrievalService(this.curatorFrameworkWrapper.asCuratorFramework(), ZooKeeperUtils.getLeaderPath(ZooKeeperUtils.getRestServerNode()), this.configuration);
    }

    @Override
    public void close() throws Exception {
        this.curatorFrameworkWrapper.close();
    }
}

