/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.DefaultSubtaskAttemptNumberStore;
import org.apache.flink.runtime.executiongraph.MutableVertexAttemptNumberStore;
import org.apache.flink.runtime.executiongraph.SubtaskAttemptNumberStore;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class DefaultVertexAttemptNumberStore
implements MutableVertexAttemptNumberStore {
    private final Map<JobVertexID, List<Integer>> vertexSubtaskToAttemptCounts = new HashMap<JobVertexID, List<Integer>>();

    @Override
    public SubtaskAttemptNumberStore getAttemptCounts(JobVertexID vertexId) {
        return new DefaultSubtaskAttemptNumberStore(Collections.unmodifiableList(new ArrayList(this.vertexSubtaskToAttemptCounts.getOrDefault(vertexId, Collections.emptyList()))));
    }

    @Override
    public void setAttemptCount(JobVertexID jobVertexId, int subtaskIndex, int attemptNumber) {
        Preconditions.checkArgument(subtaskIndex >= 0);
        Preconditions.checkArgument(attemptNumber >= 0);
        List attemptCounts = this.vertexSubtaskToAttemptCounts.computeIfAbsent(jobVertexId, ignored -> new ArrayList(32));
        while (subtaskIndex >= attemptCounts.size()) {
            attemptCounts.add(0);
        }
        attemptCounts.set(subtaskIndex, attemptNumber);
    }
}

