/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.PhysicalStateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FsSegmentDataInputStream;

public class SegmentFileStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = 1L;
    private final Path filePath;
    protected final long stateSize;
    private final long startPos;
    private final CheckpointedStateScope scope;

    public SegmentFileStateHandle(Path filePath, long startPos, long stateSize, CheckpointedStateScope scope) {
        this.filePath = filePath;
        this.stateSize = stateSize;
        this.startPos = startPos;
        this.scope = scope;
    }

    @Override
    public void discardState() {
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        FSDataInputStream inputStream = this.getFileSystem().open(this.filePath);
        return new FsSegmentDataInputStream(inputStream, this.startPos, this.stateSize);
    }

    @Override
    public Optional<byte[]> asBytesIfInMemory() {
        return Optional.empty();
    }

    @Override
    public PhysicalStateHandleID getStreamStateHandleID() {
        return new PhysicalStateHandleID(this.filePath.toUri().toString());
    }

    public long getStartPos() {
        return this.startPos;
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    public CheckpointedStateScope getScope() {
        return this.scope;
    }

    private FileSystem getFileSystem() throws IOException {
        return FileSystem.get(this.filePath.toUri());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentFileStateHandle that = (SegmentFileStateHandle)o;
        return super.equals(that) && this.startPos == that.startPos && this.stateSize == that.stateSize && this.scope.equals((Object)that.scope);
    }

    public int hashCode() {
        int result = this.getFilePath().hashCode();
        result = 31 * result + Objects.hashCode(this.startPos);
        result = 31 * result + Objects.hashCode(this.stateSize);
        result = 31 * result + Objects.hashCode((Object)this.scope);
        return result;
    }

    public String toString() {
        return String.format("Segment File State: %s [Starting Position: %d, %d bytes]", this.getFilePath(), this.startPos, this.stateSize);
    }
}

