/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.rest;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.RestClientConfiguration;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public final class RestClusterClientConfiguration {
    private final RestClientConfiguration restClientConfiguration;
    private final long awaitLeaderTimeout;
    private final int retryMaxAttempts;
    private final long retryDelay;

    private RestClusterClientConfiguration(RestClientConfiguration endpointConfiguration, long awaitLeaderTimeout, int retryMaxAttempts, long retryDelay) {
        Preconditions.checkArgument(awaitLeaderTimeout >= 0L, "awaitLeaderTimeout must be equal to or greater than 0");
        Preconditions.checkArgument(retryMaxAttempts >= 0, "retryMaxAttempts must be equal to or greater than 0");
        Preconditions.checkArgument(retryDelay >= 0L, "retryDelay must be equal to or greater than 0");
        this.restClientConfiguration = Preconditions.checkNotNull(endpointConfiguration);
        this.awaitLeaderTimeout = awaitLeaderTimeout;
        this.retryMaxAttempts = retryMaxAttempts;
        this.retryDelay = retryDelay;
    }

    public RestClientConfiguration getRestClientConfiguration() {
        return this.restClientConfiguration;
    }

    public long getAwaitLeaderTimeout() {
        return this.awaitLeaderTimeout;
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public static RestClusterClientConfiguration fromConfiguration(Configuration config) throws ConfigurationException {
        RestClientConfiguration restClientConfiguration = RestClientConfiguration.fromConfiguration(config);
        long awaitLeaderTimeout = config.get(RestOptions.AWAIT_LEADER_TIMEOUT);
        int retryMaxAttempts = config.get(RestOptions.RETRY_MAX_ATTEMPTS);
        long retryDelay = config.get(RestOptions.RETRY_DELAY);
        return new RestClusterClientConfiguration(restClientConfiguration, awaitLeaderTimeout, retryMaxAttempts, retryDelay);
    }
}

