/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.ratelimiting;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.ratelimiting.FlinkConnectorRateLimiter;
import org.apache.flink.shaded.guava31.com.google.common.util.concurrent.RateLimiter;

public class GuavaFlinkConnectorRateLimiter
implements FlinkConnectorRateLimiter {
    private static final long serialVersionUID = -3680641524643737192L;
    private long globalRateBytesPerSecond;
    private long localRateBytesPerSecond;
    private RuntimeContext runtimeContext;
    private RateLimiter rateLimiter;

    @Override
    public void open(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
        this.localRateBytesPerSecond = this.globalRateBytesPerSecond / (long)runtimeContext.getTaskInfo().getNumberOfParallelSubtasks();
        this.rateLimiter = RateLimiter.create(this.localRateBytesPerSecond);
    }

    @Override
    public void setRate(long globalRate) {
        this.globalRateBytesPerSecond = globalRate;
    }

    @Override
    public void acquire(int permits) {
        this.rateLimiter.acquire(Math.max(1, permits));
    }

    @Override
    public long getRate() {
        return this.globalRateBytesPerSecond;
    }

    @Override
    public void close() {
    }
}

