/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.materializedtable.scheduler;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.materializedtable.scheduler.CreateEmbeddedSchedulerWorkflowRequestBody;
import org.apache.flink.table.gateway.rest.message.materializedtable.scheduler.CreateEmbeddedSchedulerWorkflowResponseBody;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;
import org.apache.flink.table.gateway.workflow.WorkflowInfo;
import org.apache.flink.table.gateway.workflow.scheduler.EmbeddedQuartzScheduler;
import org.apache.flink.table.shaded.org.quartz.JobDetail;
import org.apache.flink.table.shaded.org.quartz.JobKey;

public class CreateEmbeddedSchedulerWorkflowHandler
extends AbstractSqlGatewayRestHandler<CreateEmbeddedSchedulerWorkflowRequestBody, CreateEmbeddedSchedulerWorkflowResponseBody, EmptyMessageParameters> {
    private final EmbeddedQuartzScheduler quartzScheduler;

    public CreateEmbeddedSchedulerWorkflowHandler(SqlGatewayService service, EmbeddedQuartzScheduler quartzScheduler, Map<String, String> responseHeaders, MessageHeaders<CreateEmbeddedSchedulerWorkflowRequestBody, CreateEmbeddedSchedulerWorkflowResponseBody, EmptyMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
        this.quartzScheduler = quartzScheduler;
    }

    @Override
    protected CompletableFuture<CreateEmbeddedSchedulerWorkflowResponseBody> handleRequest(@Nullable SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<CreateEmbeddedSchedulerWorkflowRequestBody> request) throws RestHandlerException {
        String materializedTableIdentifier = ((CreateEmbeddedSchedulerWorkflowRequestBody)request.getRequestBody()).getMaterializedTableIdentifier();
        String cronExpression = ((CreateEmbeddedSchedulerWorkflowRequestBody)request.getRequestBody()).getCronExpression();
        Map<String, String> initConfig = ((CreateEmbeddedSchedulerWorkflowRequestBody)request.getRequestBody()).getInitConfig();
        Map<String, String> executionConfig = ((CreateEmbeddedSchedulerWorkflowRequestBody)request.getRequestBody()).getExecutionConfig();
        String restEndpointURL = ((CreateEmbeddedSchedulerWorkflowRequestBody)request.getRequestBody()).getRestEndpointUrl();
        WorkflowInfo workflowInfo = new WorkflowInfo(materializedTableIdentifier, Collections.emptyMap(), initConfig == null ? Collections.emptyMap() : initConfig, executionConfig == null ? Collections.emptyMap() : executionConfig, restEndpointURL);
        try {
            JobDetail jobDetail = this.quartzScheduler.createScheduleWorkflow(workflowInfo, cronExpression);
            JobKey jobKey = jobDetail.getKey();
            return CompletableFuture.completedFuture(new CreateEmbeddedSchedulerWorkflowResponseBody(jobKey.getName(), jobKey.getGroup()));
        }
        catch (Exception e) {
            throw new RestHandlerException(e.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

