/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.formats.csv.RowDataToCsvConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ContainerNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@PublicEvolving
public final class CsvRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final RowDataToCsvConverters.RowDataToCsvConverter runtimeConverter;
    private final SerializableSupplier<CsvMapper> csvMapperSuppler;
    private transient CsvMapper csvMapper;
    private final CsvSchema csvSchema;
    private transient ObjectWriter objectWriter;
    private transient ObjectNode root;
    private transient RowDataToCsvConverters.RowDataToCsvConverter.RowDataToCsvFormatConverterContext converterContext;

    private CsvRowDataSerializationSchema(RowType rowType, CsvSchema csvSchema, SerializableSupplier<CsvMapper> csvMapperSupplier) {
        this.rowType = rowType;
        this.runtimeConverter = RowDataToCsvConverters.createRowConverter(rowType);
        this.csvSchema = csvSchema.withLineSeparator("");
        this.csvMapperSuppler = csvMapperSupplier;
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.csvMapper = (CsvMapper)this.csvMapperSuppler.get();
        this.objectWriter = this.csvMapper.writer((FormatSchema)this.csvSchema);
    }

    public byte[] serialize(RowData row) {
        if (this.root == null) {
            this.root = this.csvMapper.createObjectNode();
            this.converterContext = new RowDataToCsvConverters.RowDataToCsvConverter.RowDataToCsvFormatConverterContext(this.csvMapper, (ContainerNode<?>)this.root);
        }
        try {
            this.runtimeConverter.convert(row, this.converterContext);
            return this.objectWriter.writeValueAsBytes((Object)this.root);
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Could not serialize row '%s'.", row), t);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        CsvRowDataSerializationSchema that = (CsvRowDataSerializationSchema)o;
        CsvSchema otherSchema = that.csvSchema;
        return this.rowType.equals((Object)that.rowType) && this.csvSchema.getColumnSeparator() == otherSchema.getColumnSeparator() && Arrays.equals(this.csvSchema.getLineSeparator(), otherSchema.getLineSeparator()) && this.csvSchema.getArrayElementSeparator().equals(otherSchema.getArrayElementSeparator()) && this.csvSchema.getQuoteChar() == otherSchema.getQuoteChar() && this.csvSchema.getEscapeChar() == otherSchema.getEscapeChar() && Arrays.equals(this.csvSchema.getNullValue(), otherSchema.getNullValue());
    }

    public int hashCode() {
        return Objects.hash(this.rowType, Character.valueOf(this.csvSchema.getColumnSeparator()), this.csvSchema.getLineSeparator(), this.csvSchema.getArrayElementSeparator(), this.csvSchema.getQuoteChar(), this.csvSchema.getEscapeChar(), this.csvSchema.getNullValue());
    }

    @PublicEvolving
    public static class Builder {
        private final RowType rowType;
        private CsvSchema csvSchema;
        private boolean isScientificNotation;

        public Builder(RowType rowType) {
            Preconditions.checkNotNull((Object)rowType, (String)"Row type must not be null.");
            this.rowType = rowType;
            this.csvSchema = CsvRowSchemaConverter.convert(rowType);
        }

        public Builder setFieldDelimiter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(c).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder disableQuoteCharacter() {
            this.csvSchema = this.csvSchema.rebuild().disableQuoteChar().build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String s) {
            this.csvSchema = this.csvSchema.rebuild().setNullValue(s).build();
            return this;
        }

        public void setWriteBigDecimalInScientificNotation(boolean isScientificNotation) {
            this.isScientificNotation = isScientificNotation;
        }

        public CsvRowDataSerializationSchema build() {
            boolean isScientificNotation = this.isScientificNotation;
            return new CsvRowDataSerializationSchema(this.rowType, this.csvSchema, (SerializableSupplier<CsvMapper>)(SerializableSupplier & Serializable)() -> {
                CsvMapper csvMapper = JacksonMapperFactory.createCsvMapper();
                csvMapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, !isScientificNotation);
                csvMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
                csvMapper.configure((DatatypeFeature)JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES, false);
                return csvMapper;
            });
        }
    }
}

