/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.data.writer;

import java.io.Serializable;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.data.binary.BinaryArrayData;
import org.apache.flink.cdc.common.data.binary.BinarySegmentUtils;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.runtime.serializer.data.writer.AbstractBinaryWriter;
import org.apache.flink.core.memory.MemorySegmentFactory;

@Internal
public final class BinaryArrayWriter
extends AbstractBinaryWriter {
    private final int nullBitsSizeInBytes;
    private final BinaryArrayData array;
    private final int numElements;
    private int fixedSize;

    public BinaryArrayWriter(BinaryArrayData array, int numElements, int elementSize) {
        this.nullBitsSizeInBytes = BinaryArrayData.calculateHeaderInBytes(numElements);
        this.cursor = this.fixedSize = BinaryArrayWriter.roundNumberOfBytesToNearestWord(this.nullBitsSizeInBytes + elementSize * numElements);
        this.numElements = numElements;
        this.segment = MemorySegmentFactory.wrap((byte[])new byte[this.fixedSize]);
        this.segment.putInt(0, numElements);
        this.array = array;
    }

    @Override
    public void reset() {
        this.cursor = this.fixedSize;
        for (int i = 0; i < this.nullBitsSizeInBytes; i += 8) {
            this.segment.putLong(i, 0L);
        }
        this.segment.putInt(0, this.numElements);
    }

    @Override
    public void setNullBit(int ordinal) {
        BinarySegmentUtils.bitSet(this.segment, 4, ordinal);
    }

    public void setNullBoolean(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putBoolean(this.getElementOffset(ordinal, 1), false);
    }

    public void setNullByte(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.put(this.getElementOffset(ordinal, 1), (byte)0);
    }

    public void setNullShort(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putShort(this.getElementOffset(ordinal, 2), (short)0);
    }

    public void setNullInt(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putInt(this.getElementOffset(ordinal, 4), 0);
    }

    public void setNullLong(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putLong(this.getElementOffset(ordinal, 8), 0L);
    }

    public void setNullFloat(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putFloat(this.getElementOffset(ordinal, 4), 0.0f);
    }

    public void setNullDouble(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putDouble(this.getElementOffset(ordinal, 8), 0.0);
    }

    @Override
    public void setNullAt(int ordinal) {
        this.setNullLong(ordinal);
    }

    @Deprecated
    public void setNullAt(int pos, DataType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                this.setNullBoolean(pos);
                break;
            }
            case TINYINT: {
                this.setNullByte(pos);
                break;
            }
            case SMALLINT: {
                this.setNullShort(pos);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                this.setNullInt(pos);
                break;
            }
            case BIGINT: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                this.setNullLong(pos);
                break;
            }
            case FLOAT: {
                this.setNullFloat(pos);
                break;
            }
            case DOUBLE: {
                this.setNullDouble(pos);
                break;
            }
            default: {
                this.setNullAt(pos);
            }
        }
    }

    private int getElementOffset(int pos, int elementSize) {
        return this.nullBitsSizeInBytes + elementSize * pos;
    }

    @Override
    public int getFieldOffset(int pos) {
        return this.getElementOffset(pos, 8);
    }

    @Override
    public void setOffsetAndSize(int pos, int offset, long size) {
        long offsetAndSize = (long)offset << 32 | size;
        this.segment.putLong(this.getElementOffset(pos, 8), offsetAndSize);
    }

    @Override
    public void writeBoolean(int pos, boolean value) {
        this.segment.putBoolean(this.getElementOffset(pos, 1), value);
    }

    @Override
    public void writeByte(int pos, byte value) {
        this.segment.put(this.getElementOffset(pos, 1), value);
    }

    @Override
    public void writeShort(int pos, short value) {
        this.segment.putShort(this.getElementOffset(pos, 2), value);
    }

    @Override
    public void writeInt(int pos, int value) {
        this.segment.putInt(this.getElementOffset(pos, 4), value);
    }

    @Override
    public void writeLong(int pos, long value) {
        this.segment.putLong(this.getElementOffset(pos, 8), value);
    }

    @Override
    public void writeFloat(int pos, float value) {
        if (Float.isNaN(value)) {
            value = Float.NaN;
        }
        this.segment.putFloat(this.getElementOffset(pos, 4), value);
    }

    @Override
    public void writeDouble(int pos, double value) {
        if (Double.isNaN(value)) {
            value = Double.NaN;
        }
        this.segment.putDouble(this.getElementOffset(pos, 8), value);
    }

    @Override
    public void afterGrow() {
        this.array.pointTo(this.segment, 0, this.segment.size());
    }

    @Override
    public void complete() {
        this.array.pointTo(this.segment, 0, this.cursor);
    }

    public int getNumElements() {
        return this.numElements;
    }

    public static NullSetter createNullSetter(DataType elementType) {
        switch (elementType.getTypeRoot()) {
            case BIGINT: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case DECIMAL: 
            case ARRAY: 
            case MAP: 
            case ROW: {
                return BinaryArrayWriter::setNullLong;
            }
            case BOOLEAN: {
                return BinaryArrayWriter::setNullBoolean;
            }
            case TINYINT: {
                return BinaryArrayWriter::setNullByte;
            }
            case SMALLINT: {
                return BinaryArrayWriter::setNullShort;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return BinaryArrayWriter::setNullInt;
            }
            case FLOAT: {
                return BinaryArrayWriter::setNullFloat;
            }
            case DOUBLE: {
                return BinaryArrayWriter::setNullDouble;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalArgumentException();
    }

    public static interface NullSetter
    extends Serializable {
        public void setNull(BinaryArrayWriter var1, int var2);
    }
}

