/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.vitess.table;

import java.time.ZoneId;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.vitess.VitessSource;
import org.apache.flink.cdc.connectors.vitess.config.SchemaAdjustmentMode;
import org.apache.flink.cdc.connectors.vitess.config.TabletType;
import org.apache.flink.cdc.debezium.DebeziumSourceFunction;
import org.apache.flink.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class VitessTableSource
implements ScanTableSource {
    private final ResolvedSchema physicalSchema;
    private final String pluginName;
    private final String name;
    private final int port;
    private final String hostname;
    private final String keyspace;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    private final String tableName;
    @Nullable
    private String shard;
    private String gtid;
    private Boolean stopOnReshard;
    private Boolean tombstonesOnDelete;
    private SchemaAdjustmentMode schemaNameAdjustmentMode;
    private final TabletType tabletType;
    private final Properties dbzProperties;

    public VitessTableSource(ResolvedSchema physicalSchema, int port, String hostname, String keyspace, String tableName, @Nullable String username, @Nullable String password, @Nullable String shard, String gtid, Boolean stopOnReshard, Boolean tombstonesOnDelete, SchemaAdjustmentMode schemaNameAdjustmentMode, TabletType tabletType, String pluginName, String name, Properties dbzProperties) {
        this.physicalSchema = physicalSchema;
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.keyspace = (String)Preconditions.checkNotNull((Object)keyspace);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.username = username;
        this.password = password;
        this.shard = shard;
        this.gtid = gtid;
        this.stopOnReshard = stopOnReshard;
        this.tombstonesOnDelete = tombstonesOnDelete;
        this.schemaNameAdjustmentMode = (SchemaAdjustmentMode)((Object)Preconditions.checkNotNull((Object)((Object)schemaNameAdjustmentMode)));
        this.tabletType = (TabletType)((Object)Preconditions.checkNotNull((Object)((Object)tabletType)));
        this.pluginName = (String)Preconditions.checkNotNull((Object)pluginName);
        this.name = name;
        this.dbzProperties = dbzProperties;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.all();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.physicalSchema.toPhysicalRowDataType());
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setResultTypeInfo((TypeInformation<RowData>)typeInfo).setServerTimeZone(ZoneId.of("UTC")).build();
        DebeziumSourceFunction<RowData> sourceFunction = VitessSource.builder().hostname(this.hostname).port(this.port).keyspace(this.keyspace).tableIncludeList(this.tableName).username(this.username).password(this.password).tabletType(this.tabletType).decodingPluginName(this.pluginName).shard(this.shard).gtid(this.gtid).stopOnReshard(this.stopOnReshard).tombstonesOnDelete(this.tombstonesOnDelete).schemaNameAdjustmentMode(this.schemaNameAdjustmentMode).name(this.name).debeziumProperties(this.dbzProperties).deserializer(deserializer).build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    public DynamicTableSource copy() {
        return new VitessTableSource(this.physicalSchema, this.port, this.hostname, this.keyspace, this.tableName, this.username, this.password, this.shard, this.gtid, this.stopOnReshard, this.tombstonesOnDelete, this.schemaNameAdjustmentMode, this.tabletType, this.pluginName, this.name, this.dbzProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VitessTableSource that = (VitessTableSource)o;
        return this.port == that.port && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.pluginName, that.pluginName) && Objects.equals(this.name, that.name) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.shard, that.shard) && Objects.equals(this.gtid, that.gtid) && Objects.equals(this.stopOnReshard, that.stopOnReshard) && Objects.equals(this.tombstonesOnDelete, that.tombstonesOnDelete) && Objects.equals((Object)this.schemaNameAdjustmentMode, (Object)that.schemaNameAdjustmentMode) && this.tabletType == that.tabletType && Objects.equals(this.dbzProperties, that.dbzProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.physicalSchema, this.pluginName, this.name, this.port, this.hostname, this.keyspace, this.username, this.password, this.tableName, this.shard, this.gtid, this.stopOnReshard, this.tombstonesOnDelete, this.schemaNameAdjustmentMode, this.tabletType, this.dbzProperties});
    }

    public String toString() {
        return "VitessTableSource{physicalSchema=" + this.physicalSchema + ", pluginName='" + this.pluginName + '\'' + ", name='" + this.name + '\'' + ", port=" + this.port + ", hostname='" + this.hostname + '\'' + ", keyspace='" + this.keyspace + '\'' + ", username='" + String.valueOf(this.username) + '\'' + ", password='" + String.valueOf(this.password) + '\'' + ", tableName='" + this.tableName + '\'' + ", shard='" + String.valueOf(this.shard) + '\'' + ", gtid='" + this.gtid + '\'' + ", stopOnReshard=" + this.stopOnReshard + ", tombstonesOnDelete=" + this.tombstonesOnDelete + ", schemaNameAdjustmentMode=" + (Object)((Object)this.schemaNameAdjustmentMode) + ", tabletType=" + (Object)((Object)this.tabletType) + ", dbzProperties=" + this.dbzProperties + '}';
    }

    public String asSummaryString() {
        return "Vitess-CDC";
    }
}

