/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.internal;

import java.net.URI;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.Preconditions;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.Stopwatch;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.InternalServiceProviders;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.NameResolver;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.NameResolverProvider;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.internal.DnsNameResolver;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.internal.GrpcUtil;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";

    @Override
    public DnsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader()));
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }
}

