/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.parser.JaninoCompiler;
import org.apache.flink.cdc.runtime.parser.metadata.MetadataColumns;
import org.apache.flink.cdc.runtime.parser.metadata.TransformSchemaFactory;
import org.apache.flink.cdc.runtime.parser.metadata.TransformSqlOperatorTable;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformParser {
    private static final Logger LOG = LoggerFactory.getLogger(TransformParser.class);
    private static final String DEFAULT_SCHEMA = "default_schema";
    private static final String DEFAULT_TABLE = "TB";

    private static SqlParser getCalciteParser(String sql) {
        return SqlParser.create((String)sql, (SqlParser.Config)SqlParser.Config.DEFAULT.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).withCaseSensitive(true).withLex(Lex.JAVA));
    }

    private static RelNode sqlToRel(List<Column> columns, SqlNode sqlNode, List<UserDefinedFunctionDescriptor> udfDescriptors) {
        List<Column> columnsWithMetadata = TransformParser.copyFillMetadataColumn(columns);
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        SchemaPlus schema = rootSchema.plus();
        HashMap<String, Object> operand = new HashMap<String, Object>();
        operand.put("tableName", DEFAULT_TABLE);
        operand.put("columns", columnsWithMetadata);
        rootSchema.add(DEFAULT_SCHEMA, TransformSchemaFactory.INSTANCE.create(schema, DEFAULT_SCHEMA, operand));
        ArrayList<SqlFunction> udfFunctions = new ArrayList<SqlFunction>();
        for (UserDefinedFunctionDescriptor udf : udfDescriptors) {
            try {
                Class<?> clazz = Class.forName(udf.getClasspath());
                ScalarFunction function = ScalarFunctionImpl.create(clazz, (String)"eval");
                SqlReturnTypeInference returnTypeInference = udf.getReturnTypeHint() != null ? o -> o.getTypeFactory().createSqlType(DataTypeConverter.convertCalciteType(udf.getReturnTypeHint())) : o -> function.getReturnType(o.getTypeFactory());
                schema.add(udf.getName(), (Function)function);
                udfFunctions.add(new SqlFunction(udf.getName(), SqlKind.OTHER_FUNCTION, returnTypeInference, InferTypes.RETURN_TYPE, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to resolve UDF: " + udf, e);
            }
        }
        SqlTypeFactoryImpl factory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        CalciteCatalogReader calciteCatalogReader = new CalciteCatalogReader(rootSchema, rootSchema.path(DEFAULT_SCHEMA), (RelDataTypeFactory)factory, (CalciteConnectionConfig)new CalciteConnectionConfigImpl(new Properties()));
        TransformSqlOperatorTable transformSqlOperatorTable = TransformSqlOperatorTable.instance();
        SqlOperatorTable udfOperatorTable = SqlOperatorTables.of(udfFunctions);
        SqlValidatorWithHints validator = SqlValidatorUtil.newValidator((SqlOperatorTable)SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{transformSqlOperatorTable, udfOperatorTable}), (SqlValidatorCatalogReader)calciteCatalogReader, (RelDataTypeFactory)factory, (SqlValidator.Config)SqlValidator.Config.DEFAULT.withIdentifierExpansion(true));
        SqlNode validateSqlNode = validator.validate(sqlNode);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter(null, (SqlValidator)validator, (Prepare.CatalogReader)calciteCatalogReader, RelOptCluster.create((RelOptPlanner)new HepPlanner(new HepProgramBuilder().build()), (RexBuilder)new RexBuilder((RelDataTypeFactory)factory)), (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, SqlToRelConverter.config().withTrimUnusedFields(false));
        RelRoot relRoot = sqlToRelConverter.convertQuery(validateSqlNode, false, true);
        return relRoot.rel;
    }

    public static SqlSelect parseSelect(String statement) {
        SqlNode sqlNode = null;
        try {
            sqlNode = TransformParser.getCalciteParser(statement).parseQuery();
        }
        catch (SqlParseException e) {
            LOG.error("Statements can not be parsed. {} \n {}", (Object)statement, (Object)e);
            throw new ParseException("Statements can not be parsed.", (Throwable)e);
        }
        if (sqlNode instanceof SqlSelect) {
            return (SqlSelect)sqlNode;
        }
        throw new ParseException("Only select statements can be parsed.");
    }

    public static List<Column> generateReferencedColumns(String projectionExpression, @Nullable String filterExpression, List<Column> columns) {
        if (StringUtils.isNullOrWhitespaceOnly(projectionExpression)) {
            return new ArrayList<Column>();
        }
        HashSet<String> referencedColumnNames = new HashSet<String>();
        SqlSelect sqlProject = TransformParser.parseProjectionExpression(projectionExpression);
        if (!sqlProject.getSelectList().isEmpty()) {
            for (SqlNode sqlNode : sqlProject.getSelectList()) {
                if (sqlNode instanceof SqlBasicCall) {
                    SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                    if (SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind)) {
                        referencedColumnNames.addAll(TransformParser.parseColumnNameList((SqlNode)sqlBasicCall.getOperandList().get(0)));
                        continue;
                    }
                    throw new ParseException("Unrecognized projection expression: " + sqlBasicCall + ". Should be <EXPR> AS <IDENTIFIER>");
                }
                if (!(sqlNode instanceof SqlIdentifier)) continue;
                SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
                if (sqlIdentifier.isStar()) {
                    return columns;
                }
                referencedColumnNames.add((String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1));
            }
        }
        if (!StringUtils.isNullOrWhitespaceOnly(projectionExpression)) {
            SqlSelect sqlFilter = TransformParser.parseFilterExpression(filterExpression);
            referencedColumnNames.addAll(TransformParser.parseColumnNameList(sqlFilter.getWhere()));
        }
        return columns.stream().filter(e -> referencedColumnNames.contains(e.getName())).collect(Collectors.toList());
    }

    private static void expandWildcard(SqlSelect sqlSelect, List<Column> columns) {
        ArrayList<SqlNode> expandedNodes = new ArrayList<SqlNode>();
        for (SqlNode sqlNode : sqlSelect.getSelectList().getList()) {
            if (sqlNode instanceof SqlIdentifier && ((SqlIdentifier)sqlNode).isStar()) {
                expandedNodes.addAll(columns.stream().map(c -> new SqlIdentifier(c.getName(), SqlParserPos.QUOTED_ZERO)).collect(Collectors.toList()));
                continue;
            }
            expandedNodes.add(sqlNode);
        }
        sqlSelect.setSelectList(new SqlNodeList(expandedNodes, SqlParserPos.ZERO));
    }

    public static List<ProjectionColumn> generateProjectionColumns(String projectionExpression, List<Column> columns, List<UserDefinedFunctionDescriptor> udfDescriptors) {
        if (StringUtils.isNullOrWhitespaceOnly(projectionExpression)) {
            return new ArrayList<ProjectionColumn>();
        }
        SqlSelect sqlSelect = TransformParser.parseProjectionExpression(projectionExpression);
        if (sqlSelect.getSelectList().isEmpty()) {
            return new ArrayList<ProjectionColumn>();
        }
        TransformParser.expandWildcard(sqlSelect, columns);
        RelNode relNode = TransformParser.sqlToRel(columns, (SqlNode)sqlSelect, udfDescriptors);
        Map<String, RelDataType> relDataTypeMap = relNode.getRowType().getFieldList().stream().collect(Collectors.toMap(RelDataTypeField::getName, RelDataTypeField::getType));
        Map<String, DataType> rawDataTypeMap = columns.stream().collect(Collectors.toMap(Column::getName, Column::getType));
        Map<String, Boolean> isNotNullMap = columns.stream().collect(Collectors.toMap(Column::getName, column -> !column.getType().isNullable()));
        ArrayList<ProjectionColumn> projectionColumns = new ArrayList<ProjectionColumn>();
        for (SqlNode sqlNode : sqlSelect.getSelectList()) {
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                if (SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind)) {
                    String columnName;
                    Optional<Object> transformOptional = Optional.empty();
                    List operandList = sqlBasicCall.getOperandList();
                    if (operandList.size() == 2) {
                        transformOptional = Optional.of(operandList.get(0));
                        SqlNode sqlNode1 = (SqlNode)operandList.get(1);
                        if (sqlNode1 instanceof SqlIdentifier) {
                            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode1;
                            columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                        } else {
                            columnName = null;
                        }
                    } else {
                        columnName = null;
                    }
                    if (TransformParser.isMetadataColumn(columnName)) continue;
                    ProjectionColumn projectionColumn = transformOptional.isPresent() ? ProjectionColumn.of(columnName, DataTypeConverter.convertCalciteRelDataTypeToDataType(relDataTypeMap.get(columnName)), ((SqlNode)transformOptional.get()).toString(), JaninoCompiler.translateSqlNodeToJaninoExpression((SqlNode)transformOptional.get(), udfDescriptors), TransformParser.parseColumnNameList((SqlNode)transformOptional.get())) : ProjectionColumn.of(columnName, DataTypeConverter.convertCalciteRelDataTypeToDataType(relDataTypeMap.get(columnName)));
                    boolean hasReplacedDuplicateColumn = false;
                    for (int i = 0; i < projectionColumns.size(); ++i) {
                        if (!((ProjectionColumn)projectionColumns.get(i)).getColumnName().equals(columnName) || ((ProjectionColumn)projectionColumns.get(i)).isValidTransformedProjectionColumn()) continue;
                        hasReplacedDuplicateColumn = true;
                        projectionColumns.set(i, projectionColumn);
                        break;
                    }
                    if (hasReplacedDuplicateColumn) continue;
                    projectionColumns.add(projectionColumn);
                    continue;
                }
                throw new ParseException("Unrecognized projection expression: " + sqlBasicCall + ". Should be <EXPR> AS <IDENTIFIER>");
            }
            if (sqlNode instanceof SqlIdentifier) {
                DataType columnType;
                SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
                String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                if (rawDataTypeMap.containsKey(columnName)) {
                    columnType = rawDataTypeMap.get(columnName);
                } else if (relDataTypeMap.containsKey(columnName)) {
                    columnType = DataTypeConverter.convertCalciteRelDataTypeToDataType(relDataTypeMap.get(columnName));
                } else {
                    throw new RuntimeException(String.format("Failed to deduce column %s type", columnName));
                }
                if (TransformParser.isMetadataColumn(columnName)) {
                    projectionColumns.add(ProjectionColumn.of(columnName, columnType.notNull(), columnName, columnName, Arrays.asList(columnName)));
                    continue;
                }
                projectionColumns.add(ProjectionColumn.of(columnName, isNotNullMap.get(columnName) != false ? columnType.notNull() : columnType.nullable()));
                continue;
            }
            throw new ParseException("Unrecognized projection: " + sqlNode.toString());
        }
        return projectionColumns;
    }

    public static String translateFilterExpressionToJaninoExpression(String filterExpression, List<UserDefinedFunctionDescriptor> udfDescriptors) {
        if (StringUtils.isNullOrWhitespaceOnly(filterExpression)) {
            return "";
        }
        SqlSelect sqlSelect = TransformParser.parseFilterExpression(filterExpression);
        if (!sqlSelect.hasWhere()) {
            return "";
        }
        SqlNode where = sqlSelect.getWhere();
        return JaninoCompiler.translateSqlNodeToJaninoExpression(where, udfDescriptors);
    }

    public static List<String> parseComputedColumnNames(String projection) {
        ArrayList<String> columnNames = new ArrayList<String>();
        if (StringUtils.isNullOrWhitespaceOnly(projection)) {
            return columnNames;
        }
        SqlSelect sqlSelect = TransformParser.parseProjectionExpression(projection);
        if (sqlSelect.getSelectList().isEmpty()) {
            return columnNames;
        }
        for (SqlNode sqlNode : sqlSelect.getSelectList()) {
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                if (SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind)) {
                    String columnName = null;
                    List operandList = sqlBasicCall.getOperandList();
                    for (SqlNode operand : operandList) {
                        if (!(operand instanceof SqlIdentifier)) continue;
                        SqlIdentifier sqlIdentifier = (SqlIdentifier)operand;
                        columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                    }
                    if (columnNames.contains(columnName)) {
                        throw new ParseException("Duplicate column definitions: " + columnName);
                    }
                    columnNames.add(columnName);
                    continue;
                }
                throw new ParseException("Unrecognized projection: " + sqlBasicCall.toString());
            }
            if (sqlNode instanceof SqlIdentifier) {
                String columnName = sqlNode.toString();
                if (!TransformParser.isMetadataColumn(columnName) || columnNames.contains(columnName)) continue;
                columnNames.add(columnName);
                continue;
            }
            throw new ParseException("Unrecognized projection: " + sqlNode.toString());
        }
        return columnNames;
    }

    public static List<String> parseFilterColumnNameList(String filterExpression) {
        if (StringUtils.isNullOrWhitespaceOnly(filterExpression)) {
            return new ArrayList<String>();
        }
        SqlSelect sqlSelect = TransformParser.parseFilterExpression(filterExpression);
        if (!sqlSelect.hasWhere()) {
            return new ArrayList<String>();
        }
        SqlNode where = sqlSelect.getWhere();
        return TransformParser.parseColumnNameList(where);
    }

    private static List<String> parseColumnNameList(SqlNode sqlNode) {
        ArrayList<String> columnNameList = new ArrayList<String>();
        if (sqlNode instanceof SqlIdentifier) {
            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
            String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
            columnNameList.add(columnName);
        } else if (sqlNode instanceof SqlCall) {
            SqlCall sqlCall = (SqlCall)sqlNode;
            TransformParser.findSqlIdentifier(sqlCall.getOperandList(), columnNameList);
        } else if (sqlNode instanceof SqlNodeList) {
            SqlNodeList sqlNodeList = (SqlNodeList)sqlNode;
            TransformParser.findSqlIdentifier(sqlNodeList.getList(), columnNameList);
        }
        return columnNameList;
    }

    private static void findSqlIdentifier(List<SqlNode> sqlNodes, List<String> columnNameList) {
        for (SqlNode sqlNode : sqlNodes) {
            if (sqlNode instanceof SqlIdentifier) {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
                String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                columnNameList.add(columnName);
                continue;
            }
            if (sqlNode instanceof SqlCall) {
                SqlCall sqlCall = (SqlCall)sqlNode;
                TransformParser.findSqlIdentifier(sqlCall.getOperandList(), columnNameList);
                continue;
            }
            if (!(sqlNode instanceof SqlNodeList)) continue;
            SqlNodeList sqlNodeList = (SqlNodeList)sqlNode;
            TransformParser.findSqlIdentifier(sqlNodeList.getList(), columnNameList);
        }
    }

    private static SqlSelect parseProjectionExpression(String projection) {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT ");
        statement.append(projection);
        statement.append(" FROM ");
        statement.append(DEFAULT_TABLE);
        return TransformParser.parseSelect(statement.toString());
    }

    private static List<Column> copyFillMetadataColumn(List<Column> columns) {
        ArrayList<Column> columnsWithMetadata = new ArrayList<Column>(columns);
        MetadataColumns.METADATA_COLUMNS.stream().map(col -> Column.physicalColumn((String)col.f0, (DataType)col.f1)).forEach(columnsWithMetadata::add);
        return columnsWithMetadata;
    }

    private static boolean isMetadataColumn(String columnName) {
        return MetadataColumns.METADATA_COLUMNS.stream().anyMatch(col -> ((String)col.f0).equals(columnName));
    }

    public static SqlSelect parseFilterExpression(String filterExpression) {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT * FROM ");
        statement.append(DEFAULT_TABLE);
        if (!StringUtils.isNullOrWhitespaceOnly(filterExpression)) {
            statement.append(" WHERE ");
            statement.append(filterExpression);
        }
        return TransformParser.parseSelect(statement.toString());
    }

    public static SqlNode rewriteExpression(SqlNode sqlNode, Map<String, SqlNode> replaceMap) {
        if (sqlNode instanceof SqlCall) {
            SqlCall sqlCall = (SqlCall)sqlNode;
            List operands = sqlCall.getOperandList();
            IntStream.range(0, sqlCall.operandCount()).forEach(i -> sqlCall.setOperand(i, TransformParser.rewriteExpression((SqlNode)operands.get(i), replaceMap)));
            return sqlCall;
        }
        if (sqlNode instanceof SqlIdentifier) {
            String name;
            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
            if (sqlIdentifier.names.size() == 1 && replaceMap.containsKey(name = (String)sqlIdentifier.names.get(0))) {
                return replaceMap.get(name);
            }
            return sqlIdentifier;
        }
        if (sqlNode instanceof SqlNodeList) {
            SqlNodeList sqlNodeList = (SqlNodeList)sqlNode;
            IntStream.range(0, sqlNodeList.size()).forEach(i -> sqlNodeList.set(i, TransformParser.rewriteExpression(sqlNodeList.get(i), replaceMap)));
            return sqlNodeList;
        }
        return sqlNode;
    }

    public static String normalizeFilter(String projection, String filter) {
        if (StringUtils.isNullOrWhitespaceOnly(projection) || StringUtils.isNullOrWhitespaceOnly(filter)) {
            return filter;
        }
        SqlSelect sqlSelect = TransformParser.parseProjectionExpression(projection);
        if (sqlSelect.getSelectList().isEmpty()) {
            return filter;
        }
        HashMap<String, SqlNode> calculatedExpression = new HashMap<String, SqlNode>();
        for (SqlNode sqlNode : sqlSelect.getSelectList()) {
            List operandList;
            if (!(sqlNode instanceof SqlBasicCall)) continue;
            SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
            if (!SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind) || (operandList = sqlBasicCall.getOperandList()).size() != 2) continue;
            SqlIdentifier alias = (SqlIdentifier)operandList.get(1);
            String name = (String)alias.names.get(alias.names.size() - 1);
            SqlNode expression = (SqlNode)operandList.get(0);
            calculatedExpression.put(name, expression);
        }
        SqlNode sqlFilter = TransformParser.parseFilterExpression(filter).getWhere();
        if ((sqlFilter = TransformParser.rewriteExpression(sqlFilter, calculatedExpression)) != null) {
            return sqlFilter.toString();
        }
        return filter;
    }

    public static boolean hasAsterisk(@Nullable String projection) {
        if (StringUtils.isNullOrWhitespaceOnly(projection)) {
            return false;
        }
        return TransformParser.parseProjectionExpression(projection).getOperandList().stream().anyMatch(TransformParser::hasAsterisk);
    }

    private static boolean hasAsterisk(SqlNode sqlNode) {
        if (sqlNode instanceof SqlIdentifier) {
            return ((SqlIdentifier)sqlNode).isStar();
        }
        if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
            return sqlBasicCall.getOperandList().stream().anyMatch(TransformParser::hasAsterisk);
        }
        if (sqlNode instanceof SqlNodeList) {
            SqlNodeList sqlNodeList = (SqlNodeList)sqlNode;
            return sqlNodeList.getList().stream().anyMatch(TransformParser::hasAsterisk);
        }
        return false;
    }
}

