/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.event;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.runtime.serializer.MapSerializer;
import org.apache.flink.cdc.runtime.serializer.StringSerializer;
import org.apache.flink.cdc.runtime.serializer.TableIdSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class RenameColumnEventSerializer
extends TypeSerializerSingleton<RenameColumnEvent> {
    private static final long serialVersionUID = 1L;
    public static final RenameColumnEventSerializer INSTANCE = new RenameColumnEventSerializer();
    private final TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
    private final MapSerializer<String, String> nameMapSerializer = new MapSerializer<String, String>(StringSerializer.INSTANCE, StringSerializer.INSTANCE);

    public boolean isImmutableType() {
        return false;
    }

    public RenameColumnEvent createInstance() {
        return new RenameColumnEvent(TableId.tableId("unknown"), Collections.emptyMap());
    }

    public RenameColumnEvent copy(RenameColumnEvent from) {
        return new RenameColumnEvent(from.tableId(), this.nameMapSerializer.copy(from.getNameMapping()));
    }

    public RenameColumnEvent copy(RenameColumnEvent from, RenameColumnEvent reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(RenameColumnEvent record, DataOutputView target) throws IOException {
        this.tableIdSerializer.serialize(record.tableId(), target);
        this.nameMapSerializer.serialize(record.getNameMapping(), target);
    }

    public RenameColumnEvent deserialize(DataInputView source) throws IOException {
        return new RenameColumnEvent(this.tableIdSerializer.deserialize(source), (Map<String, String>)this.nameMapSerializer.deserialize(source));
    }

    public RenameColumnEvent deserialize(RenameColumnEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<RenameColumnEvent> snapshotConfiguration() {
        return new RenameColumnEventSerializerSnapshot();
    }

    public static final class RenameColumnEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<RenameColumnEvent> {
        public RenameColumnEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

