/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.vitess.Module;
import io.debezium.connector.vitess.VitessSourceInfoStructMaker;
import io.debezium.connector.vitess.connection.VitessTabletType;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessConnectorConfig
extends RelationalDatabaseConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessConnectorConfig.class);
    private static final String VITESS_CONFIG_GROUP_PREFIX = "vitess.";
    private static final int DEFAULT_VTGATE_PORT = 15991;
    public static final Field VTGATE_HOST = Field.create("database." + JdbcConfiguration.HOSTNAME).withDisplayName("Vitess database hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("Resolvable hostname or IP address of the Vitess VTGate gRPC server.");
    public static final Field VTGATE_PORT = Field.create("database." + JdbcConfiguration.PORT).withDisplayName("Vitess database port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(15991).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isInteger).withDescription("Port of the Vitess VTGate gRPC server.");
    public static final Field VTGATE_USER = Field.create("database." + JdbcConfiguration.USER).withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the user to be used when connecting the Vitess VTGate gRPC server.");
    public static final Field VTGATE_PASSWORD = Field.create("database." + JdbcConfiguration.PASSWORD).withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password of the user to be used when connecting the Vitess VTGate gRPC server.");
    public static final Field KEYSPACE = Field.create("vitess.keyspace").withDisplayName("Keyspace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("Vitess Keyspace is equivalent to MySQL database (a.k.a schema). E.p. \"commerce\"");
    public static final Field SHARD = Field.create("vitess.shard").withDisplayName("Shard").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Single shard of which keyspace to read data from.E.p. \"0\" for an unsharded keyspace. Or \"-80\" for the -80 shard of the sharded keyspace.");
    public static final Field GTID = Field.create("vitess.gtid").withDisplayName("gtid").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withDefault("current").withImportance(ConfigDef.Importance.HIGH).withDescription("Single GTID from where to start reading from for a given shard. It has to be set together with vitess.shard");
    public static final Field TABLET_TYPE = Field.create("vitess.tablet.type").withDisplayName("Tablet type to get data-changes").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(VitessTabletType.MASTER.name()).withDescription("Tablet type used to get latest vgtid from Vtctld and get data-changes from Vtgate. Value can be MASTER, REPLICA, and RDONLY.");
    public static final Field STOP_ON_RESHARD_FLAG = Field.create("vitess.stop_on_reshard").withDisplayName("VStream flag stop_on_reshard").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Control StopOnReshard VStream flag. If set true, the old VStream will be stopped after a reshard operation.");
    public static final Field KEEPALIVE_INTERVAL_MS = Field.create("vitess.keepalive.interval.ms").withDisplayName("VStream gRPC keepalive interval (ms)").withType(ConfigDef.Type.LONG).withDefault(Long.MAX_VALUE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Control the interval between periodic gPRC keepalive pings for VStream. Defaults to Long.MAX_VALUE (disabled).");
    public static final Field GRPC_HEADERS = Field.create("vitess.grpc.headers").withDisplayName("VStream gRPC headers").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify a comma-separated list of gRPC headers. Defaults to empty");
    public static final Field GRPC_MAX_INBOUND_MESSAGE_SIZE = Field.create("vitess.grpc.max_inbound_message_size").withDisplayName("VStream gRPC maxInboundMessageSize").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(0x400000).withImportance(ConfigDef.Importance.MEDIUM).withValidation(Field::isInteger).withDescription("Specify the maximum message size in bytes allowed to be received on the channel.");
    public static final Field INCLUDE_UNKNOWN_DATATYPES = Field.create("include.unknown.datatypes").withDisplayName("Include unknown datatypes").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify whether the fields of data type not supported by Debezium should be processed:'false' (the default) omits the fields; 'true' converts the field into an implementation dependent binary representation.");
    protected static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Vitess").type(KEYSPACE, SHARD, GTID, VTGATE_HOST, VTGATE_PORT, VTGATE_USER, VTGATE_PASSWORD, TABLET_TYPE, STOP_ON_RESHARD_FLAG, KEEPALIVE_INTERVAL_MS, GRPC_HEADERS, GRPC_MAX_INBOUND_MESSAGE_SIZE, BINARY_HANDLING_MODE, SCHEMA_NAME_ADJUSTMENT_MODE).events(INCLUDE_UNKNOWN_DATATYPES).excluding(SCHEMA_EXCLUDE_LIST, SCHEMA_INCLUDE_LIST).create();
    public static Field.Set ALL_FIELDS = Field.setOf(CONFIG_DEFINITION.all());

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public VitessConnectorConfig(Configuration config) {
        super(config, config.getString(SERVER_NAME), null, x -> x.schema() + "." + x.table(), -1, ColumnFilterMode.CATALOG);
    }

    @Override
    public String getContextName() {
        return Module.contextName();
    }

    @Override
    public String getConnectorName() {
        return Module.name();
    }

    @Override
    protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new VitessSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    public String getKeyspace() {
        return this.getConfig().getString(KEYSPACE);
    }

    public String getShard() {
        return this.getConfig().getString(SHARD);
    }

    public String getGtid() {
        return this.getConfig().getString(GTID);
    }

    public String getVtgateHost() {
        return this.getConfig().getString(VTGATE_HOST);
    }

    public int getVtgatePort() {
        return this.getConfig().getInteger(VTGATE_PORT);
    }

    public String getVtgateUsername() {
        return this.getConfig().getString(VTGATE_USER);
    }

    public String getVtgatePassword() {
        return this.getConfig().getString(VTGATE_PASSWORD);
    }

    public String getTabletType() {
        return this.getConfig().getString(TABLET_TYPE);
    }

    public boolean getStopOnReshard() {
        return this.getConfig().getBoolean(STOP_ON_RESHARD_FLAG);
    }

    public Duration getKeepaliveInterval() {
        return this.getConfig().getDuration(KEEPALIVE_INTERVAL_MS, ChronoUnit.MILLIS);
    }

    public Map<String, String> getGrpcHeaders() {
        String grpcHeaders = this.getConfig().getString(GRPC_HEADERS);
        if (grpcHeaders == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> grpcHeadersMap = new HashMap<String, String>();
        for (String header : grpcHeaders.split(",")) {
            String[] keyAndValue = header.split(":");
            if (keyAndValue.length == 2) {
                grpcHeadersMap.put(keyAndValue[0], keyAndValue[1]);
                continue;
            }
            LOGGER.warn("The following gRPC header is invalid: {}", (Object)header);
        }
        return Collections.unmodifiableMap(grpcHeadersMap);
    }

    public int getGrpcMaxInboundMessageSize() {
        return this.getConfig().getInteger(GRPC_MAX_INBOUND_MESSAGE_SIZE);
    }

    public boolean includeUnknownDatatypes() {
        return this.getConfig().getBoolean(INCLUDE_UNKNOWN_DATATYPES);
    }
}

