/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.types.utils.runtime.DataInputViewStream;
import org.apache.flink.cdc.common.types.utils.runtime.DataOutputViewStream;
import org.apache.flink.cdc.common.utils.InstantiationUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class NullableSerializerWrapper<T>
extends TypeSerializer<T> {
    private final TypeSerializer<T> innerSerializer;

    public NullableSerializerWrapper(TypeSerializer<T> innerSerializer) {
        this.innerSerializer = innerSerializer;
    }

    public boolean isImmutableType() {
        return this.innerSerializer.isImmutableType();
    }

    public TypeSerializer<T> duplicate() {
        return new NullableSerializerWrapper<T>(this.innerSerializer.duplicate());
    }

    public T createInstance() {
        return null;
    }

    public T copy(T from) {
        if (from == null) {
            return null;
        }
        return (T)this.innerSerializer.copy(from);
    }

    public T copy(T from, T reuse) {
        if (from == null) {
            return null;
        }
        return (T)this.innerSerializer.copy(from, reuse);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        if (record == null) {
            target.writeBoolean(true);
        } else {
            target.writeBoolean(false);
            this.innerSerializer.serialize(record, target);
        }
    }

    public T deserialize(DataInputView source) throws IOException {
        if (source.readBoolean()) {
            return null;
        }
        return (T)this.innerSerializer.deserialize(source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NullableSerializerWrapper that = (NullableSerializerWrapper)((Object)o);
        return this.innerSerializer.equals(that.innerSerializer);
    }

    public int hashCode() {
        return this.innerSerializer.hashCode();
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new NullableSerializerWrapperSnapshot<T>(this.innerSerializer);
    }

    public static final class NullableSerializerWrapperSnapshot<T>
    implements TypeSerializerSnapshot<T> {
        private static final int CURRENT_VERSION = 1;
        private TypeSerializer<T> innerSerializer;

        public NullableSerializerWrapperSnapshot() {
        }

        public NullableSerializerWrapperSnapshot(TypeSerializer<T> innerSerializer) {
            this.innerSerializer = innerSerializer;
        }

        public int getCurrentVersion() {
            return 1;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            DataOutputViewStream outStream = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject(outStream, this.innerSerializer);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader classLoader) throws IOException {
            try {
                DataInputViewStream inStream = new DataInputViewStream(in);
                this.innerSerializer = (TypeSerializer)InstantiationUtil.deserializeObject(inStream, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public TypeSerializer<T> restoreSerializer() {
            return new NullableSerializerWrapper<T>(this.innerSerializer);
        }

        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            if (!(newSerializer instanceof NullableSerializerWrapper)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            NullableSerializerWrapper newNullableSerializerWrapper = (NullableSerializerWrapper)newSerializer;
            if (!this.innerSerializer.equals((Object)newNullableSerializerWrapper.innerSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

