/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.Java;

public class JaninoCompiler {
    private static final List<SqlTypeName> SQL_TYPE_NAME_IGNORE = Arrays.asList(SqlTypeName.SYMBOL);
    private static final List<String> NO_OPERAND_TIMESTAMP_FUNCTIONS = Arrays.asList("LOCALTIME", "LOCALTIMESTAMP", "CURRENT_TIME", "CURRENT_DATE", "CURRENT_TIMESTAMP");
    public static final String DEFAULT_EPOCH_TIME = "__epoch_time__";
    public static final String DEFAULT_TIME_ZONE = "__time_zone__";

    public static String loadSystemFunction(String expression) {
        return "import static org.apache.flink.cdc.runtime.functions.SystemFunctionUtils.*;" + expression;
    }

    public static ExpressionEvaluator compileExpression(String expression, List<String> argumentNames, List<Class<?>> argumentClasses, Class<?> returnClass) {
        ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
        expressionEvaluator.setParameters(argumentNames.toArray(new String[0]), argumentClasses.toArray(new Class[0]));
        expressionEvaluator.setExpressionType(returnClass);
        try {
            expressionEvaluator.cook(expression);
            return expressionEvaluator;
        }
        catch (CompileException e) {
            throw new InvalidProgramException("Expression cannot be compiled. This is a bug. Please file an issue.\nExpression: " + expression, (Throwable)e);
        }
    }

    public static String translateSqlNodeToJaninoExpression(SqlNode transform) {
        Java.Rvalue rvalue = JaninoCompiler.translateSqlNodeToJaninoRvalue(transform);
        if (rvalue != null) {
            return rvalue.toString();
        }
        return "";
    }

    public static Java.Rvalue translateSqlNodeToJaninoRvalue(SqlNode transform) {
        if (transform instanceof SqlIdentifier) {
            return JaninoCompiler.translateSqlIdentifier((SqlIdentifier)transform);
        }
        if (transform instanceof SqlBasicCall) {
            return JaninoCompiler.translateSqlBasicCall((SqlBasicCall)transform);
        }
        if (transform instanceof SqlCase) {
            return JaninoCompiler.translateSqlCase((SqlCase)transform);
        }
        if (transform instanceof SqlLiteral) {
            return JaninoCompiler.translateSqlSqlLiteral((SqlLiteral)transform);
        }
        return null;
    }

    private static Java.Rvalue translateSqlIdentifier(SqlIdentifier sqlIdentifier) {
        String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
        if (NO_OPERAND_TIMESTAMP_FUNCTIONS.contains(columnName)) {
            return JaninoCompiler.generateNoOperandTimestampFunctionOperation(columnName);
        }
        return new Java.AmbiguousName(Location.NOWHERE, new String[]{columnName});
    }

    private static Java.Rvalue translateSqlSqlLiteral(SqlLiteral sqlLiteral) {
        if (sqlLiteral.getValue() == null) {
            return new Java.NullLiteral(Location.NOWHERE);
        }
        String value = sqlLiteral.getValue().toString();
        if (sqlLiteral instanceof SqlCharStringLiteral) {
            value = "\"" + value.substring(1, value.length() - 1) + "\"";
        }
        if (SQL_TYPE_NAME_IGNORE.contains(sqlLiteral.getTypeName())) {
            value = "\"" + value + "\"";
        }
        return new Java.AmbiguousName(Location.NOWHERE, new String[]{value});
    }

    private static Java.Rvalue translateSqlBasicCall(SqlBasicCall sqlBasicCall) {
        List operandList = sqlBasicCall.getOperandList();
        ArrayList<Java.Rvalue> atoms = new ArrayList<Java.Rvalue>();
        for (SqlNode sqlNode : operandList) {
            JaninoCompiler.translateSqlNodeToAtoms(sqlNode, atoms);
        }
        if (NO_OPERAND_TIMESTAMP_FUNCTIONS.contains(sqlBasicCall.getOperator().getName())) {
            atoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_EPOCH_TIME}));
            atoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_TIME_ZONE}));
        }
        return JaninoCompiler.sqlBasicCallToJaninoRvalue(sqlBasicCall, atoms.toArray(new Java.Rvalue[0]));
    }

    private static Java.Rvalue translateSqlCase(SqlCase sqlCase) {
        Java.Rvalue elseAtoms;
        SqlNodeList whenOperands = sqlCase.getWhenOperands();
        SqlNodeList thenOperands = sqlCase.getThenOperands();
        SqlNode elseOperand = sqlCase.getElseOperand();
        ArrayList<Java.Rvalue> whenAtoms = new ArrayList<Java.Rvalue>();
        for (Object sqlNode : whenOperands) {
            JaninoCompiler.translateSqlNodeToAtoms((SqlNode)sqlNode, whenAtoms);
        }
        ArrayList<Java.Rvalue> thenAtoms = new ArrayList<Java.Rvalue>();
        for (SqlNode sqlNode : thenOperands) {
            JaninoCompiler.translateSqlNodeToAtoms(sqlNode, thenAtoms);
        }
        Java.Rvalue sqlCaseRvalueTemp = elseAtoms = JaninoCompiler.translateSqlNodeToJaninoRvalue(elseOperand);
        for (int i = whenAtoms.size() - 1; i >= 0; --i) {
            sqlCaseRvalueTemp = new Java.ConditionalExpression(Location.NOWHERE, (Java.Rvalue)whenAtoms.get(i), (Java.Rvalue)thenAtoms.get(i), sqlCaseRvalueTemp);
        }
        return new Java.ParenthesizedExpression(Location.NOWHERE, sqlCaseRvalueTemp);
    }

    private static void translateSqlNodeToAtoms(SqlNode sqlNode, List<Java.Rvalue> atoms) {
        if (sqlNode instanceof SqlIdentifier) {
            atoms.add(JaninoCompiler.translateSqlIdentifier((SqlIdentifier)sqlNode));
        } else if (sqlNode instanceof SqlLiteral) {
            atoms.add(JaninoCompiler.translateSqlSqlLiteral((SqlLiteral)sqlNode));
        } else if (sqlNode instanceof SqlBasicCall) {
            atoms.add(JaninoCompiler.translateSqlBasicCall((SqlBasicCall)sqlNode));
        } else if (sqlNode instanceof SqlNodeList) {
            for (SqlNode node : (SqlNodeList)sqlNode) {
                JaninoCompiler.translateSqlNodeToAtoms(node, atoms);
            }
        } else if (sqlNode instanceof SqlCase) {
            atoms.add(JaninoCompiler.translateSqlCase((SqlCase)sqlNode));
        }
    }

    private static Java.Rvalue sqlBasicCallToJaninoRvalue(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        switch (sqlBasicCall.getKind()) {
            case AND: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "&&");
            }
            case OR: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "||");
            }
            case NOT: {
                return JaninoCompiler.generateUnaryOperation("!", atoms[0]);
            }
            case EQUALS: {
                return JaninoCompiler.generateEqualsOperation(sqlBasicCall, atoms);
            }
            case NOT_EQUALS: {
                return JaninoCompiler.generateUnaryOperation("!", JaninoCompiler.generateEqualsOperation(sqlBasicCall, atoms));
            }
            case IS_NULL: {
                return JaninoCompiler.generateUnaryOperation("null == ", atoms[0]);
            }
            case IS_NOT_NULL: {
                return JaninoCompiler.generateUnaryOperation("null != ", atoms[0]);
            }
            case IS_FALSE: 
            case IS_NOT_TRUE: {
                return JaninoCompiler.generateUnaryOperation("false == ", atoms[0]);
            }
            case IS_TRUE: 
            case IS_NOT_FALSE: {
                return JaninoCompiler.generateUnaryOperation("true == ", atoms[0]);
            }
            case BETWEEN: 
            case IN: 
            case NOT_IN: 
            case LIKE: 
            case CEIL: 
            case FLOOR: 
            case TRIM: 
            case OTHER_FUNCTION: {
                return JaninoCompiler.generateOtherFunctionOperation(sqlBasicCall, atoms);
            }
            case PLUS: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "+");
            }
            case MINUS: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "-");
            }
            case TIMES: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "*");
            }
            case DIVIDE: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "/");
            }
            case MOD: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "%");
            }
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, sqlBasicCall.getKind().sql);
            }
            case OTHER: {
                return JaninoCompiler.generateOtherOperation(sqlBasicCall, atoms);
            }
        }
        throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
    }

    private static Java.Rvalue generateUnaryOperation(String operator, Java.Rvalue atom) {
        return new Java.UnaryOperation(Location.NOWHERE, operator, atom);
    }

    private static Java.Rvalue generateBinaryOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms, String operator) {
        if (atoms.length != 2) {
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        return new Java.BinaryOperation(Location.NOWHERE, atoms[0], operator, atoms[1]);
    }

    private static Java.Rvalue generateEqualsOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        if (atoms.length != 2) {
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase("VALUE_EQUALS"), atoms);
    }

    private static Java.Rvalue generateOtherOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        if (sqlBasicCall.getOperator().getName().equals("||")) {
            return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase("CONCAT"), atoms);
        }
        throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
    }

    private static Java.Rvalue generateOtherFunctionOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        String operationName = sqlBasicCall.getOperator().getName().toUpperCase();
        if (operationName.equals("IF")) {
            if (atoms.length == 3) {
                return new Java.ConditionalExpression(Location.NOWHERE, atoms[0], atoms[1], atoms[2]);
            }
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        if (operationName.equals("NOW")) {
            return JaninoCompiler.generateNoOperandTimestampFunctionOperation(operationName);
        }
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(sqlBasicCall.getOperator().getName()), atoms);
    }

    private static Java.Rvalue generateNoOperandTimestampFunctionOperation(String operationName) {
        ArrayList<Java.AmbiguousName> timestampFunctionParam = new ArrayList<Java.AmbiguousName>();
        timestampFunctionParam.add(new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_EPOCH_TIME}));
        timestampFunctionParam.add(new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_TIME_ZONE}));
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(operationName), timestampFunctionParam.toArray(new Java.Rvalue[0]));
    }
}

