/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.tidb.TiKVChangeEventDeserializationSchema;
import org.apache.flink.cdc.connectors.tidb.table.RowDataTiKVEventDeserializationSchemaBase;
import org.apache.flink.cdc.connectors.tidb.table.TiKVMetadataConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.tikv.common.TiConfiguration;
import org.tikv.common.codec.TableCodec;
import org.tikv.common.key.RowKey;
import org.tikv.kvproto.Cdcpb;

public class RowDataTiKVChangeEventDeserializationSchema
extends RowDataTiKVEventDeserializationSchemaBase
implements TiKVChangeEventDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<RowData> resultTypeInfo;

    public RowDataTiKVChangeEventDeserializationSchema(TiConfiguration tiConf, String database, String tableName, TypeInformation<RowData> resultTypeInfo, TiKVMetadataConverter[] metadataConverters, RowType physicalDataType) {
        super(tiConf, database, tableName, metadataConverters, physicalDataType);
        this.resultTypeInfo = (TypeInformation)Preconditions.checkNotNull(resultTypeInfo);
    }

    @Override
    public void deserialize(Cdcpb.Event.Row row, Collector<RowData> out) throws Exception {
        if (this.tableInfo == null) {
            this.tableInfo = this.fetchTableInfo();
        }
        RowKey rowKey = RowKey.decode(row.getKey().toByteArray());
        long handle = rowKey.getHandle();
        switch (row.getOpType()) {
            case DELETE: {
                Object[] tikvValues = TableCodec.decodeObjects(row.getOldValue().toByteArray(), handle, this.tableInfo);
                RowData rowDataDelete = (RowData)this.physicalConverter.convert(tikvValues, this.tableInfo, null);
                rowDataDelete.setRowKind(RowKind.DELETE);
                this.emit(new TiKVMetadataConverter.TiKVRowValue(row), rowDataDelete, out);
                break;
            }
            case PUT: {
                try {
                    Object[] tikvValues = TableCodec.decodeObjects(row.getValue().toByteArray(), RowKey.decode(row.getKey().toByteArray()).getHandle(), this.tableInfo);
                    if (row.getOldValue() == null || row.getOldValue().isEmpty()) {
                        RowData rowDataUpdateBefore = (RowData)this.physicalConverter.convert(tikvValues, this.tableInfo, null);
                        rowDataUpdateBefore.setRowKind(RowKind.INSERT);
                        this.emit(new TiKVMetadataConverter.TiKVRowValue(row), rowDataUpdateBefore, out);
                        break;
                    }
                    RowData rowDataUpdateAfter = (RowData)this.physicalConverter.convert(tikvValues, this.tableInfo, null);
                    rowDataUpdateAfter.setRowKind(RowKind.UPDATE_AFTER);
                    this.emit(new TiKVMetadataConverter.TiKVRowValue(row), rowDataUpdateAfter, out);
                    break;
                }
                catch (RuntimeException e) {
                    throw new FlinkRuntimeException(String.format("Fail to deserialize row: %s, table: %s", row, this.tableInfo.getId()), (Throwable)e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown Row Op Type: " + row.getOpType());
            }
        }
    }

    public TypeInformation getProducedType() {
        return this.resultTypeInfo;
    }
}

