/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb;

import org.apache.flink.cdc.connectors.tidb.TiKVChangeEventDeserializationSchema;
import org.apache.flink.cdc.connectors.tidb.TiKVRichParallelSourceFunction;
import org.apache.flink.cdc.connectors.tidb.TiKVSnapshotEventDeserializationSchema;
import org.apache.flink.cdc.connectors.tidb.table.StartupOptions;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.tikv.common.TiConfiguration;

public class TiDBSource {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private String database;
        private String tableName;
        private StartupOptions startupOptions = StartupOptions.initial();
        private TiConfiguration tiConf;
        private TiKVSnapshotEventDeserializationSchema<T> snapshotEventDeserializationSchema;
        private TiKVChangeEventDeserializationSchema<T> changeEventDeserializationSchema;

        public Builder<T> database(String database) {
            this.database = database;
            return this;
        }

        public Builder<T> tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder<T> snapshotEventDeserializer(TiKVSnapshotEventDeserializationSchema<T> snapshotEventDeserializationSchema) {
            this.snapshotEventDeserializationSchema = snapshotEventDeserializationSchema;
            return this;
        }

        public Builder<T> changeEventDeserializer(TiKVChangeEventDeserializationSchema<T> changeEventDeserializationSchema) {
            this.changeEventDeserializationSchema = changeEventDeserializationSchema;
            return this;
        }

        public Builder<T> startupOptions(StartupOptions startupOptions) {
            this.startupOptions = startupOptions;
            return this;
        }

        public Builder<T> tiConf(TiConfiguration tiConf) {
            this.tiConf = tiConf;
            return this;
        }

        public RichParallelSourceFunction<T> build() {
            return new TiKVRichParallelSourceFunction<T>(this.snapshotEventDeserializationSchema, this.changeEventDeserializationSchema, this.tiConf, this.startupOptions.startupMode, this.database, this.tableName);
        }
    }
}

