/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression.visitor;

import org.tikv.common.expression.ComparisonBinaryExpression;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.LogicalBinaryExpression;
import org.tikv.common.expression.visitor.DefaultVisitor;

public class PseudoCostCalculator
extends DefaultVisitor<Double, Void> {
    public static double calculateCost(Expression expr) {
        PseudoCostCalculator calc = new PseudoCostCalculator();
        return expr.accept(calc, null);
    }

    @Override
    protected Double process(Expression node, Void context) {
        return 1.0;
    }

    @Override
    protected Double visit(LogicalBinaryExpression node, Void context) {
        double leftCost = node.getLeft().accept(this, context);
        double rightCost = node.getLeft().accept(this, context);
        switch (node.getCompType()) {
            case AND: {
                return leftCost * rightCost;
            }
            case OR: 
            case XOR: {
                return leftCost + rightCost;
            }
        }
        return 1.0;
    }

    @Override
    protected Double visit(ComparisonBinaryExpression node, Void context) {
        switch (node.getComparisonType()) {
            case EQUAL: {
                return 0.01;
            }
            case GREATER_EQUAL: 
            case GREATER_THAN: 
            case LESS_EQUAL: 
            case LESS_THAN: {
                return 0.3;
            }
            case NOT_EQUAL: {
                return 0.99;
            }
        }
        return 1.0;
    }
}

