/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import java.util.Base64;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.exception.CastingException;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.TypeException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.Converter;
import org.tikv.common.types.IntegerType;
import org.tikv.common.types.MySQLType;

public class BitType
extends IntegerType {
    public static final BitType BIT = new BitType(MySQLType.TypeBit);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeBit};
    private static final long MAX_BIT_LENGTH = 64L;

    private BitType(MySQLType tp) {
        super(tp);
    }

    protected BitType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    public long getSize() {
        if (this.isLengthUnSpecified()) {
            return this.getPrefixSize() + this.getDefaultDataSize();
        }
        return this.getPrefixSize() + (this.getLength() + 7L) / 8L;
    }

    @Override
    public String getName() {
        return "BIT";
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        Long result = Converter.safeConvertToUnsigned(value, this.unsignedUpperBound());
        long targetLength = this.getLength();
        long upperBound = 1L << (int)targetLength;
        if (targetLength < 64L && Long.compareUnsigned(result, upperBound) >= 0) {
            throw ConvertOverflowException.newUpperBoundException(result, upperBound);
        }
        return result;
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        switch (flag) {
            case 9: {
                return Codec.IntegerCodec.readUVarLong(cdi);
            }
            case 4: {
                return Codec.IntegerCodec.readULong(cdi);
            }
        }
        throw new TypeException("Invalid IntegerType flag: " + flag);
    }

    @Override
    public boolean isUnsigned() {
        return true;
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        Long result = 0L;
        byte[] bytes = Base64.getDecoder().decode(value);
        if (bytes.length <= 0 || bytes.length > 8) {
            throw new CastingException("Base64 format Bit Type to Long Overflow");
        }
        int size = bytes.length;
        for (int i = 0; i < bytes.length; ++i) {
            result = result + ((long)(bytes[size - i - 1] & 0xFF) << (size - i - 1) * 8);
        }
        return result;
    }

    @Override
    public boolean isPushDownSupported() {
        return false;
    }
}

