/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.txn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.common.TiSession;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.importer.ImporterClient;
import org.tikv.common.importer.SwitchTiKVModeClient;
import org.tikv.common.key.Key;
import org.tikv.common.operation.iterator.ConcreteScanIterator;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.Batch;
import org.tikv.common.util.ClientUtils;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.tikv.shade.com.google.protobuf.ByteString;

public class KVClient
implements AutoCloseable {
    private final TiSession tiSession;
    private static final Logger logger = LoggerFactory.getLogger(KVClient.class);
    private static final int MAX_BATCH_LIMIT = 1024;
    private static final int BATCH_GET_SIZE = 16384;
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;
    private final TiConfiguration conf;
    private final ExecutorService executorService;

    public KVClient(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder clientBuilder, TiSession session) {
        Objects.requireNonNull(conf, "conf is null");
        Objects.requireNonNull(clientBuilder, "clientBuilder is null");
        this.tiSession = session;
        this.conf = conf;
        this.clientBuilder = clientBuilder;
        this.executorService = Executors.newFixedThreadPool(conf.getKvClientConcurrency(), new ThreadFactoryBuilder().setNameFormat("kvclient-pool-%d").setDaemon(true).build());
    }

    @Override
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public ByteString get(ByteString key, long version) throws GrpcException {
        ConcreteBackOffer backOffer = ConcreteBackOffer.newGetBackOff();
        while (true) {
            RegionStoreClient client = this.clientBuilder.build(key);
            try {
                return client.get(backOffer, key, version);
            }
            catch (TiKVException e) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                continue;
            }
            break;
        }
    }

    public List<Kvrpcpb.KvPair> batchGet(BackOffer backOffer, List<ByteString> keys, long version) throws GrpcException {
        return this.doSendBatchGet(backOffer, keys, version);
    }

    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey, long version) throws GrpcException {
        Iterator<Kvrpcpb.KvPair> iterator = this.scanIterator(this.conf, this.clientBuilder, startKey, endKey, version);
        ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
        iterator.forEachRemaining(result::add);
        return result;
    }

    public List<Kvrpcpb.KvPair> scan(ByteString startKey, long version, int limit) throws GrpcException {
        Iterator<Kvrpcpb.KvPair> iterator = this.scanIterator(this.conf, this.clientBuilder, startKey, version, limit);
        ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
        iterator.forEachRemaining(result::add);
        return result;
    }

    public List<Kvrpcpb.KvPair> scan(ByteString startKey, long version) throws GrpcException {
        return this.scan(startKey, version, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void ingest(List<Pair<ByteString, ByteString>> list) throws GrpcException {
        if (list.isEmpty()) {
            return;
        }
        Key min = Key.MAX;
        Key max = Key.MIN;
        HashMap map = new HashMap(list.size());
        for (Pair<ByteString, ByteString> pair2 : list) {
            map.put(pair2.first, pair2.second);
            Key key = Key.toRawKey(((ByteString)pair2.first).toByteArray());
            if (key.compareTo(min) < 0) {
                min = key;
            }
            if (key.compareTo(max) <= 0) continue;
            max = key;
        }
        SwitchTiKVModeClient switchTiKVModeClient = this.tiSession.getSwitchTiKVModeClient();
        try {
            switchTiKVModeClient.switchTiKVToNormalMode();
            ArrayList<byte[]> splitKeys = new ArrayList<byte[]>(2);
            splitKeys.add(min.getBytes());
            splitKeys.add(max.next().getBytes());
            this.tiSession.splitRegionAndScatter(splitKeys);
            this.tiSession.getRegionManager().invalidateAll();
            switchTiKVModeClient.keepTiKVToImportMode();
            List<ByteString> keyList = list.stream().map(pair -> (ByteString)pair.first).collect(Collectors.toList());
            Map<TiRegion, List<ByteString>> groupKeys = ClientUtils.groupKeysByRegion(this.clientBuilder.getRegionManager(), keyList, (BackOffer)ConcreteBackOffer.newRawKVBackOff());
            for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
                TiRegion region = entry.getKey();
                List<ByteString> keys = entry.getValue();
                List<Pair<ByteString, ByteString>> kvs = keys.stream().map(k -> Pair.create(k, map.get(k))).collect(Collectors.toList());
                this.doIngest(region, kvs);
            }
        }
        finally {
            switchTiKVModeClient.stopKeepTiKVToImportMode();
            switchTiKVModeClient.switchTiKVToNormalMode();
        }
    }

    private List<Kvrpcpb.KvPair> doSendBatchGet(BackOffer backOffer, List<ByteString> keys, long version) {
        ExecutorCompletionService<List<Kvrpcpb.KvPair>> completionService = new ExecutorCompletionService<List<Kvrpcpb.KvPair>>(this.executorService);
        List<Batch> batches = ClientUtils.getBatches(backOffer, keys, 16384, 1024, this.clientBuilder);
        for (Batch batch : batches) {
            completionService.submit(() -> this.doSendBatchGetInBatchesWithRetry(batch.getBackOffer(), batch, version));
        }
        return ClientUtils.getKvPairs(completionService, batches, 40000);
    }

    private List<Kvrpcpb.KvPair> doSendBatchGetInBatchesWithRetry(BackOffer backOffer, Batch batch, long version) {
        TiRegion currentRegion;
        TiRegion oldRegion = batch.getRegion();
        if (oldRegion.equals(currentRegion = this.clientBuilder.getRegionManager().getRegionByKey(oldRegion.getStartKey()))) {
            RegionStoreClient client = this.clientBuilder.build(batch.getRegion());
            try {
                return client.batchGet(backOffer, batch.getKeys(), version);
            }
            catch (TiKVException e) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                this.clientBuilder.getRegionManager().invalidateRegion(batch.getRegion());
                logger.warn("ReSplitting ranges for BatchGetRequest", (Throwable)e);
                return this.doSendBatchGetWithRefetchRegion(backOffer, batch, version);
            }
        }
        return this.doSendBatchGetWithRefetchRegion(backOffer, batch, version);
    }

    private List<Kvrpcpb.KvPair> doSendBatchGetWithRefetchRegion(BackOffer backOffer, Batch batch, long version) {
        List<Batch> retryBatches = ClientUtils.getBatches(backOffer, batch.getKeys(), 16384, 1024, this.clientBuilder);
        ArrayList<Kvrpcpb.KvPair> results = new ArrayList<Kvrpcpb.KvPair>();
        for (Batch retryBatch : retryBatches) {
            List<Kvrpcpb.KvPair> batchResult = this.doSendBatchGetInBatchesWithRetry(backOffer, retryBatch, version);
            results.addAll(batchResult);
        }
        return results;
    }

    private Iterator<Kvrpcpb.KvPair> scanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, long version) {
        return new ConcreteScanIterator(conf, builder, startKey, endKey, version);
    }

    private Iterator<Kvrpcpb.KvPair> scanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, long version, int limit) {
        return new ConcreteScanIterator(conf, builder, startKey, version, limit);
    }

    private void doIngest(TiRegion region, List<Pair<ByteString, ByteString>> sortedList) throws GrpcException {
        if (sortedList.isEmpty()) {
            return;
        }
        ByteString uuid = ByteString.copyFrom(ClientUtils.genUUID());
        Key minKey = Key.toRawKey((ByteString)sortedList.get((int)0).first);
        Key maxKey = Key.toRawKey((ByteString)sortedList.get((int)(sortedList.size() - 1)).first);
        ImporterClient importerClient = new ImporterClient(this.tiSession, uuid, minKey, maxKey, region, 0L);
        importerClient.write(sortedList.iterator());
    }
}

