/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.metrics;

import org.apache.flink.metrics.MetricGroup;

public class TiDBSourceMetrics {
    private final MetricGroup metricGroup;
    private long processTime = 0L;
    private long fetchDelay = 0L;
    private long emitDelay = 0L;

    public TiDBSourceMetrics(MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
    }

    public void registerMetrics() {
        this.metricGroup.gauge("currentFetchEventTimeLag", this::getFetchDelay);
        this.metricGroup.gauge("currentEmitEventTimeLag", this::getEmitDelay);
        this.metricGroup.gauge("sourceIdleTime", this::getIdleTime);
    }

    public long getFetchDelay() {
        return this.fetchDelay;
    }

    public long getEmitDelay() {
        return this.emitDelay;
    }

    public long getIdleTime() {
        if (this.processTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.processTime;
    }

    public void recordProcessTime(long processTime) {
        this.processTime = processTime;
    }

    public void recordFetchDelay(long fetchDelay) {
        this.fetchDelay = fetchDelay;
    }

    public void recordEmitDelay(long emitDelay) {
        this.emitDelay = emitDelay;
    }
}

