/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.tidb.TDBSourceOptions;
import org.apache.flink.cdc.connectors.tidb.TiDBSource;
import org.apache.flink.cdc.connectors.tidb.table.RowDataTiKVChangeEventDeserializationSchema;
import org.apache.flink.cdc.connectors.tidb.table.RowDataTiKVSnapshotEventDeserializationSchema;
import org.apache.flink.cdc.connectors.tidb.table.StartupOptions;
import org.apache.flink.cdc.connectors.tidb.table.TiKVMetadataConverter;
import org.apache.flink.cdc.connectors.tidb.table.TiKVReadableMetadata;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.tikv.common.TiConfiguration;

public class TiDBTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    private final String database;
    private final String tableName;
    private final String pdAddresses;
    private final StartupOptions startupOptions;
    private final Map<String, String> options;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public TiDBTableSource(ResolvedSchema physicalSchema, String database, String tableName, String pdAddresses, StartupOptions startupOptions, Map<String, String> options) {
        this.physicalSchema = physicalSchema;
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.pdAddresses = (String)Preconditions.checkNotNull((Object)pdAddresses);
        this.startupOptions = startupOptions;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.options = options;
        this.metadataKeys = Collections.emptyList();
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        TiConfiguration tiConf = TDBSourceOptions.getTiConfiguration(this.pdAddresses, this.options);
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        TiKVMetadataConverter[] metadataConverters = this.getMetadataConverters();
        RowDataTiKVSnapshotEventDeserializationSchema snapshotEventDeserializationSchema = new RowDataTiKVSnapshotEventDeserializationSchema(tiConf, this.database, this.tableName, (TypeInformation<RowData>)typeInfo, metadataConverters, physicalDataType);
        RowDataTiKVChangeEventDeserializationSchema changeEventDeserializationSchema = new RowDataTiKVChangeEventDeserializationSchema(tiConf, this.database, this.tableName, (TypeInformation<RowData>)typeInfo, metadataConverters, physicalDataType);
        TiDBSource.Builder<RowData> builder = TiDBSource.builder().database(this.database).tableName(this.tableName).startupOptions(this.startupOptions).tiConf(tiConf).snapshotEventDeserializer(snapshotEventDeserializationSchema).changeEventDeserializer(changeEventDeserializationSchema);
        return SourceFunctionProvider.of(builder.build(), (boolean)false);
    }

    public DynamicTableSource copy() {
        TiDBTableSource source = new TiDBTableSource(this.physicalSchema, this.database, this.tableName, this.pdAddresses, this.startupOptions, this.options);
        source.producedDataType = this.producedDataType;
        source.metadataKeys = this.metadataKeys;
        return source;
    }

    private TiKVMetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new TiKVMetadataConverter[0];
        }
        return (TiKVMetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(TiKVReadableMetadata.createTiKVReadableMetadata(this.database, this.tableName)).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(TiKVReadableMetadata::getConverter).toArray(TiKVMetadataConverter[]::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TiDBTableSource that = (TiDBTableSource)o;
        return Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.pdAddresses, that.pdAddresses) && Objects.equals(this.startupOptions, that.startupOptions) && Objects.equals(this.options, that.options) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.database, this.tableName, this.pdAddresses, this.startupOptions, this.options, this.producedDataType, this.metadataKeys);
    }

    public String asSummaryString() {
        return "TiDB-CDC";
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(TiKVReadableMetadata.createTiKVReadableMetadata(this.database, this.tableName)).collect(Collectors.toMap(TiKVReadableMetadata::getKey, TiKVReadableMetadata::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }
}

