/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.factories;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.common.factories.Factory;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;

@PublicEvolving
public class FactoryHelper {
    private final Factory factory;
    private final Factory.Context context;

    private FactoryHelper(Factory factory, Factory.Context context) {
        this.factory = factory;
        this.context = context;
    }

    public static FactoryHelper createFactoryHelper(Factory factory, Factory.Context context) {
        return new FactoryHelper(factory, context);
    }

    public static void validateFactoryOptions(Factory factory, Configuration configuration) {
        FactoryHelper.validateFactoryOptions(factory.requiredOptions(), factory.optionalOptions(), configuration);
    }

    public static void validateFactoryOptions(Set<ConfigOption<?>> requiredOptions, Set<ConfigOption<?>> optionalOptions, Configuration configuration) {
        List missingRequiredOptions = requiredOptions.stream().filter(option -> configuration.get(option) == null).map(ConfigOption::key).sorted().collect(Collectors.toList());
        if (!missingRequiredOptions.isEmpty()) {
            throw new ValidationException(String.format("One or more required options are missing.\n\nMissing required options are:\n\n%s", String.join((CharSequence)"\n", missingRequiredOptions)));
        }
        optionalOptions.forEach(configuration::getOptional);
    }

    public static void validateUnconsumedKeys(String factoryIdentifier, Set<String> allOptionKeys, Set<String> consumedOptionKeys) {
        HashSet<String> remainingOptionKeys = new HashSet<String>(allOptionKeys);
        remainingOptionKeys.removeAll(consumedOptionKeys);
        if (!remainingOptionKeys.isEmpty()) {
            throw new ValidationException(String.format("Unsupported options found for '%s'.\n\nUnsupported options:\n\n%s\n\nSupported options:\n\n%s", factoryIdentifier, remainingOptionKeys.stream().sorted().collect(Collectors.joining("\n")), String.join((CharSequence)"\n", consumedOptionKeys)));
        }
    }

    public void validate() {
        Set<String> allOptionKeys = Stream.concat(this.factory.requiredOptions().stream().map(ConfigOption::key), this.factory.optionalOptions().stream().map(ConfigOption::key)).collect(Collectors.toSet());
        FactoryHelper.validateFactoryOptions(this.factory, this.context.getFactoryConfiguration());
        FactoryHelper.validateUnconsumedKeys(this.factory.identifier(), this.context.getFactoryConfiguration().getKeys(), allOptionKeys);
    }

    public void validateExcept(String ... prefixesToSkip) {
        Preconditions.checkArgument(prefixesToSkip.length > 0, "Prefixes to skip can not be empty.", new Object[0]);
        List<String> prefixesList = Arrays.asList(prefixesToSkip);
        Set<String> allOptionKeys = Stream.concat(this.factory.requiredOptions().stream().map(ConfigOption::key), this.factory.optionalOptions().stream().map(ConfigOption::key)).collect(Collectors.toSet());
        Set<String> filteredOptionKeys = this.context.getFactoryConfiguration().getKeys().stream().filter(key -> prefixesList.stream().noneMatch(key::startsWith)).collect(Collectors.toSet());
        FactoryHelper.validateFactoryOptions(this.factory, this.context.getFactoryConfiguration());
        FactoryHelper.validateUnconsumedKeys(this.factory.identifier(), filteredOptionKeys, allOptionKeys);
    }

    public ReadableConfig getFormatConfig(String formatPrefix) {
        String prefix = formatPrefix + ".";
        HashMap formatConfigMap = new HashMap();
        this.context.getFactoryConfiguration().toMap().forEach((k, v) -> {
            if (k.startsWith(prefix)) {
                formatConfigMap.put(k.substring(prefix.length()), v);
            }
        });
        return org.apache.flink.configuration.Configuration.fromMap(formatConfigMap);
    }

    public static class DefaultContext
    implements Factory.Context {
        private final Configuration factoryConfiguration;
        private final ClassLoader classLoader;
        private final Configuration pipelineConfiguration;

        public DefaultContext(Configuration factoryConfiguration, Configuration pipelineConfiguration, ClassLoader classLoader) {
            this.factoryConfiguration = factoryConfiguration;
            this.pipelineConfiguration = pipelineConfiguration;
            this.classLoader = classLoader;
        }

        @Override
        public Configuration getFactoryConfiguration() {
            return this.factoryConfiguration;
        }

        @Override
        public Configuration getPipelineConfiguration() {
            return this.pipelineConfiguration;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

