/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.EnumeratedValue;
import io.debezium.util.Clock;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum SourceTimestampMode implements EnumeratedValue
{
    COMMIT("commit"){

        @Override
        protected Instant getTimestamp(Clock clock, ResultSet resultSet) throws SQLException {
            return resultSet.getTimestamp(resultSet.getMetaData().getColumnCount()).toInstant();
        }

        @Override
        protected String lsnTimestampSelectStatement() {
            return ", TODATETIMEOFFSET([#db].sys.fn_cdc_map_lsn_to_time([__$start_lsn]), DATEPART(TZOFFSET, SYSDATETIMEOFFSET()))";
        }
    }
    ,
    PROCESSING("processing"){

        @Override
        protected Instant getTimestamp(Clock clock, ResultSet resultSet) {
            return clock.currentTime();
        }

        @Override
        protected String lsnTimestampSelectStatement() {
            return "";
        }
    };

    private final String value;

    private SourceTimestampMode(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    protected abstract Instant getTimestamp(Clock var1, ResultSet var2) throws SQLException;

    protected abstract String lsnTimestampSelectStatement();

    protected List<String> getResultColumnNames(ResultSetMetaData rsmd, int columnDataOffset) throws SQLException {
        int columnCount = rsmd.getColumnCount() - (columnDataOffset - 1);
        if (this.equals(COMMIT)) {
            --columnCount;
        }
        ArrayList<String> columns = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columns.add(rsmd.getColumnName(columnDataOffset + i));
        }
        return columns;
    }

    public static SourceTimestampMode getDefaultMode() {
        return COMMIT;
    }

    static SourceTimestampMode fromMode(String mode) {
        return Arrays.stream(SourceTimestampMode.values()).filter(s -> s.name().equalsIgnoreCase(mode)).findFirst().orElseGet(SourceTimestampMode::getDefaultMode);
    }
}

