/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

public class ObjectUtils {
    public static Object plus(Object number, int augend) throws ArithmeticException {
        if (number instanceof Integer) {
            return Math.addExact((Integer)number, augend);
        }
        if (number instanceof Long) {
            return Math.addExact((Long)number, (long)augend);
        }
        if (number instanceof BigInteger) {
            return ((BigInteger)number).add(BigInteger.valueOf(augend));
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).add(BigDecimal.valueOf(augend));
        }
        throw new UnsupportedOperationException(String.format("Unsupported type %s for numeric plus.", number.getClass().getSimpleName()));
    }

    public static BigDecimal minus(Object minuend, Object subtrahend) {
        if (!minuend.getClass().equals(subtrahend.getClass())) {
            throw new IllegalStateException(String.format("Unsupported operand type, the minuend type %s is different with subtrahend type %s.", minuend.getClass().getSimpleName(), subtrahend.getClass().getSimpleName()));
        }
        if (minuend instanceof Integer) {
            return BigDecimal.valueOf(((Integer)minuend).intValue()).subtract(BigDecimal.valueOf(((Integer)subtrahend).intValue()));
        }
        if (minuend instanceof Long) {
            return BigDecimal.valueOf((Long)minuend).subtract(BigDecimal.valueOf((Long)subtrahend));
        }
        if (minuend instanceof BigInteger) {
            return new BigDecimal(((BigInteger)minuend).subtract((BigInteger)subtrahend).toString());
        }
        if (minuend instanceof BigDecimal) {
            return ((BigDecimal)minuend).subtract((BigDecimal)subtrahend);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type %s for numeric minus.", minuend.getClass().getSimpleName()));
    }

    public static int compare(Object obj1, Object obj2) {
        Comparable c1 = (Comparable)obj1;
        Comparable c2 = (Comparable)obj2;
        return c1.compareTo(c2);
    }

    public static int doubleCompare(double arg1, double arg2) {
        BigDecimal bigDecimal1 = BigDecimal.valueOf(arg1);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(arg2);
        return bigDecimal1.compareTo(bigDecimal2);
    }
}

